package com.ejie.y41e.service;


import java.util.List;

import com.ejie.y41e.model.Y41eBloque;
import com.ejie.y41e.model.Y41eRelEncuestaBloque;

/**
 * Y41eRelEncuestaBloqueService
 *  
 */

public interface Y41eRelEncuestaBloqueService extends Y41eGenericoService<Y41eRelEncuestaBloque> {

    /**
     * Asocia los bloques seleccionados a la encuesta
     * @param idEncuesta Long
     * @param listaBloquesSeleccionados List<Y41eBloque>
     */
    public void asosiarBloques(Long idEncuesta, List<Y41eBloque> listaBloquesSeleccionados);

    /**
     * Ordena las bloques según el orden pasado
     * @param orden String
     * @param idEncuesta String
     */
    public void moverBloque(String orden, String idEncuesta);


    /* (non-Javadoc)
     * @see com.ejie.y41e.service.Y41eGenericoService#remove(java.lang.Object)
     */
    @Override
    public void remove(Y41eRelEncuestaBloque bean);

}