package com.ejie.y41e.service;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41e.dao.Y41eGenericoDao;
import com.ejie.y41e.dao.Y41ePreguntaEnlazadaDao;
import com.ejie.y41e.dao.Y41eRelBloquePreguntaDao;
import com.ejie.y41e.model.Y41ePregunta;
import com.ejie.y41e.model.Y41ePreguntaEnlazada;
import com.ejie.y41e.model.Y41eRelBloquePregunta;

/**
 * Y41eRelBloquePreguntaServiceImpl
 *  
 */

@Service(value = "y41eRelBloquePreguntaService")
public class Y41eRelBloquePreguntaServiceImpl extends Y41eGenericoServiceImpl<Y41eRelBloquePregunta> implements Y41eRelBloquePreguntaService {

    @Autowired
    private Y41eRelBloquePreguntaDao relBloquePreguntaDao;
    @Autowired
    private Y41ePreguntaEnlazadaDao y41ePreguntaEnlazadaDao;

    @Override()
    protected Y41eGenericoDao<Y41eRelBloquePregunta> getDao() {
        return this.relBloquePreguntaDao;
    }

    /**
     * Asocia las preguntas al bloque indicado
     * @param idBloque Long
     * @param listaPreguntasSeleccionadas List<Y41ePregunta>
     */
    @Override
    public void asosiarPreguntas(Long idBloque, List<Y41ePregunta> listaPreguntasSeleccionadas){
        this.relBloquePreguntaDao.asosiarPreguntas(idBloque, listaPreguntasSeleccionadas);
    }

    /**
     * Ordena las pregutnas según el orden pasado
     *
     * @param ordenIds String
     * @param idBloque String
     */
    @Override
    public void moverPregunta(String ordenIds, String idBloque){
        this.relBloquePreguntaDao.moverPregunta(ordenIds, idBloque);
    }

    /* (non-Javadoc)
     * @see com.ejie.y41e.service.Y41eGenericoServiceImpl#remove(java.lang.Object)
     */
    @Transactional(rollbackFor = Throwable.class)
    @Override
    public void remove(Y41eRelBloquePregunta bean){
        //borrar bloque
        this.relBloquePreguntaDao.remove(bean);
        //borrar preguntas enlazadas a la pregunta
        if(bean.getBloque().getIdEncuesta()!=0){
            Y41ePreguntaEnlazada preguntaEnlazada = new Y41ePreguntaEnlazada(bean.getBloque().getIdEncuesta(), 
                    bean.getBloque().getIdBloque(), bean.getPregunta().getIdPregunta());
            y41ePreguntaEnlazadaDao.remove(preguntaEnlazada);
        }
    }

}

