package com.ejie.y41e.service;


import java.util.List;

import com.ejie.y41e.model.Y41ePregunta;
import com.ejie.y41e.model.Y41eRelBloquePregunta;

/**
 * Y41eRelBloquePreguntaService
 *  
 */

public interface Y41eRelBloquePreguntaService extends Y41eGenericoService<Y41eRelBloquePregunta> {

    /**
     * Asocia las preguntas al bloque indicado
     * @param idBloque Long
     * @param listaPreguntasSeleccionadas List<Y41ePregunta>
     */
    public void asosiarPreguntas(Long idBloque, List<Y41ePregunta> listaPreguntasSeleccionadas);

    /**
     * Ordena las pregutnas según el orden pasado
     *
     * @param ordenIds String
     * @param idBloque String
     */
    public void moverPregunta(String ordenIds, String idBloque);

    /* (non-Javadoc)
     * @see com.ejie.y41e.service.Y41eGenericoService#remove(java.lang.Object)
     */
    @Override
    public void remove(Y41eRelBloquePregunta bean);

}


