package com.ejie.y41e.service;


import java.util.List;

import com.ejie.y41e.model.Y41ePregunta;

/**
 * Y41ePreguntaService
 *  
 */

public interface Y41ePreguntaService extends Y41eGenericoService<Y41ePregunta> {

    /**
     * Comprueba que no existe ninguna encuesta enviada o respondida para el id de la pregunta.
     * @param idPregunta Long
     * @return El área o áreas a la que pertenece la encuesta
     */
    public Integer validarPreguntaEnviada(Long idPregunta);

    /**
     * Comprueba que el bloque no esté asociado a una encuesta enviada.
     * @param idBloque Long
     * @return Integer
     */
    public Integer validarDesasociarEnviada(Long idBloque);

    /**
     * Comprueba que el bloque no esté asociado a una encuesta enviada.
     * @param idBloque Long
     * @return Integer
     */
    public Integer validarDesasociarEncuesta(Long idBloque);

    /**
     * Comprueba que la pregunta pertenece a una encuesta.
     * @param idPregunta Long
     * @return El área o áreas a la que pertenece la encuesta
     */
    public Integer validarPreguntaEncuesta(Long idPregunta);

    /**
     * Añade la pregunta y la asigna al bloque indicado
     * @param pregunta Y41ePregunta
     * @return
     */
    public void addPreguntaBloque(Y41ePregunta pregunta);

    /**
     * Obtiene el suggest de bloques
     * @param pregunta Y41ePregunta
     * @param startsWith boolean
     * @return List<Y41ePregunta>
     */
    public List<Y41ePregunta> findAllSuggest(Y41ePregunta pregunta, boolean startsWith);

    /* (non-Javadoc)
     * @see com.ejie.y41e.service.Y41eGenericoService#add(java.lang.Object)
     */
    @Override
    public Y41ePregunta add(Y41ePregunta bean);

    /* (non-Javadoc)
     * @see com.ejie.y41e.service.Y41eGenericoService#find(java.lang.Object)
     */
    @Override
    public Y41ePregunta find(Y41ePregunta bean);

    /* (non-Javadoc)
     * @see com.ejie.y41e.service.Y41eGenericoService#update(java.lang.Object)
     */
    @Override
    public Y41ePregunta update(Y41ePregunta bean);

    /**
     * Devuelve la pregunta si tiene configurado avisos
     * @param idPregunta Long
     * @param idTipoRespuesta Long
     * @return Y41ePregunta
     */
    public Y41ePregunta findPreguntaAviso(Long idPregunta, Long idTipoRespuesta);

}