package com.ejie.y41e.service;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41e.dao.Y41eGenericoDao;
import com.ejie.y41e.dao.Y41ePreguntaDao;
import com.ejie.y41e.dao.Y41ePreguntaEnlazadaDao;
import com.ejie.y41e.model.Y41ePregunta;
import com.ejie.y41e.model.Y41ePreguntaEnlazada;

/**
 * Y41ePreguntaEnlazadaServiceImpl
 *  
 */

@Service(value = "y41ePreguntaEnlazadaService")
public class Y41ePreguntaEnlazadaServiceImpl extends Y41eGenericoServiceImpl<Y41ePreguntaEnlazada> implements Y41ePreguntaEnlazadaService {

    @Autowired
    private Y41ePreguntaEnlazadaDao y41ePreguntaEnlazadaDao;
    @Autowired
    private Y41ePreguntaDao y41ePreguntaDao;


    @Override()
    protected Y41eGenericoDao<Y41ePreguntaEnlazada> getDao() {
        return this.y41ePreguntaEnlazadaDao;
    }

    /**
     * Obtiene el árbol de preguntas enlazadas
     * @param idPreguntaPadre Long
     * @param idBloqueEnlazar Long
     * @param idEncuestaEnlazar Long
     * @return Y41ePregunta
     */
    @Override
    public Y41ePregunta findTreeEnlazadas(Long idPreguntaPadre, Long idBloqueEnlazar, Long idEncuestaEnlazar){
        //buscar pregunta padre
        Y41ePregunta preguntaPadre = new Y41ePregunta(idPreguntaPadre);
        preguntaPadre = this.y41ePreguntaDao.find(preguntaPadre);
        preguntaPadre.setListaEnlazadas(this.y41ePreguntaEnlazadaDao.findTreeEnlazadas(idPreguntaPadre, idBloqueEnlazar, idEncuestaEnlazar));
        return preguntaPadre;
    }

    /**
     * Guardar las preguntas o bloques asociados a una pregunta
     * @param selectedIds List<String>
     * @param preguntaEnlazada Y41ePreguntaEnlazada
     */
    @Override
    @Transactional(rollbackFor = Throwable.class)
    public void addEnlazadas(List<String> selectedIds, Y41ePreguntaEnlazada preguntaEnlazada){
        y41ePreguntaEnlazadaDao.remove(preguntaEnlazada);
        y41ePreguntaEnlazadaDao.addEnlazadas(selectedIds);
    }
}

