package com.ejie.y41e.service;


import java.util.List;

import com.ejie.y41e.model.Y41ePregunta;
import com.ejie.y41e.model.Y41ePreguntaEnlazada;

/**
 * Y41ePreguntaEnlazadaService
 *  
 */

public interface Y41ePreguntaEnlazadaService extends Y41eGenericoService<Y41ePreguntaEnlazada> {

    /**
     * Obtiene el árbol de preguntas enlazadas
     * @param idPreguntaPadre Long
     * @param idBloqueEnlazar Long
     * @param idEncuestaEnlazar Long
     * @return Y41ePregunta
     */
    public Y41ePregunta findTreeEnlazadas(Long idPreguntaPadre, Long idBloqueEnlazar, Long idEncuestaEnlazar);

    /**
     * Guardar las preguntas o bloques asociados a una pregunta
     * @param selectedIds List<String>
     * @param preguntaEnlazada Y41ePreguntaEnlazada
     */
    public void addEnlazadas(List<String> selectedIds, Y41ePreguntaEnlazada preguntaEnlazada);

}