package com.ejie.y41e.service;

import java.util.List;

import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.TableRowDto;

/**
 *  
 *
 * @param <T>
 */
public interface Y41eGenericoService<T> {

    /**
     * Finds a single row in the T table.
     *
     * @param bean
     *            T
     * @return T
     */
    T find(T bean);

    /**
     * Finds a list of rows in the T table.
     *
     * @param bean
     *            T
     * @param jqGridRequestDto
     *            JQGridRequestDto
     * @return List<T>
     */
    List<T> findAll(T bean, JQGridRequestDto jqGridRequestDto);

    /**
     * Finds rows in the T table using like.
     *
     * @param bean
     *            T
     * @param jqGridRequestDto
     *            JQGridRequestDto
     * @param startsWith
     *            Boolean
     * @return List<T>
     */
    List<T> findAllLike(T bean, JQGridRequestDto jqGridRequestDto, Boolean startsWith);

    /*
     * OPERACIONES RUP_TABLE
     */

    /**
     * Filter method in the T table.
     *
     * @param filter
     *            T
     * @param jqGridRequestDto
     *            JQGridRequestDto
     * @param startsWith
     *            Boolean
     * @return JQGridResponseDto<T>
     */
    JQGridResponseDto<T> filter(T filter, JQGridRequestDto jqGridRequestDto, Boolean startsWith);

    /**
     * Searches rows in the T table.
     *
     * @param filter
     *            T
     * @param search
     *            T
     * @param jqGridRequestDto
     *            JQGridRequestDto
     * @param startsWith
     *            Boolean
     * @return List<TableRowDto<T>>
     */
    List<TableRowDto<T>> search(T filter, T search, JQGridRequestDto jqGridRequestDto, Boolean startsWith);

    /**
     * Reorder the selection made in T table.
     *
     * @param filter
     *            T
     * @param jqGridRequestDto
     *            JQGridRequestDto
     * @param startsWith
     *            Boolean
     * @return Object
     */
    Object reorderSelection(T filter, JQGridRequestDto jqGridRequestDto, Boolean startsWith);

    /**
     * Inserts a single row in the T table.
     *
     * @param bean
     *            T
     * @return T
     */
    T add(T bean);

    /**
     * Updates a single row in the T table.
     *
     * @param bean
     *            T
     * @return T
     */
    T update(T bean);

    /**
     * Deletes a single row in the T table.
     *
     * @param bean
     *            T
     */
    void remove(T bean);

    /**
     * Removes rows from the T table.
     *
     * @param filter
     *            T
     * @param jqGridRequestDto
     *            JQGridRequestDto
     * @param startsWith
     *            Boolean
     */
    void removeMultiple(T filter, JQGridRequestDto jqGridRequestDto, Boolean startsWith);
}
