package com.ejie.y41e.service;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41e.dao.Y41eEncuestaDao;
import com.ejie.y41e.dao.Y41eEnviosDao;
import com.ejie.y41e.dao.Y41eGenericoDao;
import com.ejie.y41e.model.Y41eEncuesta;
import com.ejie.y41e.model.Y41eEnvio;

/**
 * Y41eEnviosServiceImpl  
 *  
 */

@Service(value = "y41eEnviosService")
public class Y41eEnviosServiceImpl extends Y41eGenericoServiceImpl<Y41eEnvio> implements Y41eEnviosService {

    @Autowired
    private Y41eEnviosDao y41eEnviosDao;
    @Autowired
    private Y41eEncuestaDao y41eEncuestaDao;

    @Override()
    protected Y41eGenericoDao<Y41eEnvio> getDao() {
        return this.y41eEnviosDao;
    }

    /**
     * Guarda los envíos
     * @param encuesta Y41eEncuesta
     * @param listaEnvios List<Y41eEnvio>
     */
    @Transactional(rollbackFor = Throwable.class)
    @Override
    public void guardarEnvios(Y41eEncuesta encuesta, List<Y41eEnvio> listaEnvios){
        //guardar envios
        this.y41eEnviosDao.guardarEnvios(listaEnvios);
        //cambiar encuesta a enviar
        this.y41eEncuestaDao.enviarEncuesta(encuesta);
    }
}

