package com.ejie.y41e.service;

import java.util.List;

import com.ejie.y41e.model.Y41eEncuesta;
import com.ejie.y41e.model.Y41eEnvio;
import com.ejie.y41e.model.webservice.Y41eEncuestaWs;
import com.ejie.y41e.model.webservice.Y41eResultadoWs;
import com.ejie.y41e.model.webservice.Y41eUsuarioWs;

/**
 * Y41eEncuestaWSService
 *  
 */

public interface Y41eEncuestaWSService{

    /**
     * Valida los campos obligatorios
     * 
     * @param encuesta Y41eEncuestaWs
     * @return Y41eResultadoWs
     */
    public Y41eResultadoWs validarCamposObligatorios(Y41eEncuestaWs encuesta);

    /**
     * Crea una lista de envios con los datos de entrada
     * @param encuesta Y41eEncuesta
     * @param listaUsuarios  List<Y41eUsuarioWs>
     * @return List<Y41eEnvio>
     */
    public List<Y41eEnvio> crearEnvios(Y41eEncuesta encuesta, List<Y41eUsuarioWs> listaUsuarios);

    /**
     * Realiza el envio de los mails
     * @param encuesta Y41eEncuesta
     * @param listaEnvios List<Y41eEnvio>
     */
    public void notificarEnvios(Y41eEncuesta encuesta, List<Y41eEnvio> listaEnvios);

}


