package com.ejie.y41e.service;
import java.util.List;
import java.util.Locale;

import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.stereotype.Service;

import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.y41e.common.Y41eConstants;
import com.ejie.y41e.dao.Y41eEncuestaDao;
import com.ejie.y41e.dao.Y41eGenericoDao;
import com.ejie.y41e.dao.Y41ePreguntaEnlazadaDao;
import com.ejie.y41e.dao.Y41eRelBloquePreguntaDao;
import com.ejie.y41e.dao.Y41eRelEncuestaBloqueDao;
import com.ejie.y41e.dao.Y41eTipoRespuestaDao;
import com.ejie.y41e.model.Y41eBloque;
import com.ejie.y41e.model.Y41eEncuesta;
import com.ejie.y41e.model.Y41ePregunta;
import com.ejie.y41e.model.Y41eResultados;
import com.ejie.y41e.model.Y41eTipoRespuesta;
import com.ejie.y41e.model.excel.Y41eExcelCelda;
import com.ejie.y41e.model.excel.Y41eExcelEstilo;
import com.ejie.y41e.model.excel.Y41eExcelHoja;
import com.ejie.y41e.model.excel.Y41eExcelModel;

/**
 * Y41eEncuestaServiceImpl
 *  
 */

@Service(value = "y41eEncuestaService")
public class Y41eEncuestaServiceImpl extends Y41eGenericoServiceImpl<Y41eEncuesta> implements Y41eEncuestaService {

    @Autowired
    private Y41eEncuestaDao y41eEncuestaDao;
    @Autowired
    private Y41eRelEncuestaBloqueDao y41eRelEncuestaBloqueDao;
    @Autowired
    private Y41eRelBloquePreguntaDao relBloquePreguntaDao;
    @Autowired
    private Y41eTipoRespuestaDao y41eTipoRespuestaDao;
    @Autowired
    private Y41ePreguntaEnlazadaDao y41ePreguntaEnlazadaDao;
    @Autowired()
    private ReloadableResourceBundleMessageSource appMessageSource;


    @Override()
    protected Y41eGenericoDao<Y41eEncuesta> getDao() {
        return this.y41eEncuestaDao;
    }

    /**
     * Comprueba que no existe ninguna encuesta enviada o respondida para el id de la encuesta.
     * 
     * @param idEncuesta Long
     * @return String el area a la que pertence la encuesta 
     *            
     */
    @Override
    public String validarEncuesta(Long idEncuesta){
        return this.y41eEncuestaDao.validarEncuesta(idEncuesta);
    }

    /**
     * Crea una encuesta como copia de la que recibe por parámetro
     * @param y41eEncuesta Y41eEncuesta
     * @return Y41eEncuesta
     */
    @Override
    public Y41eEncuesta copiarEncuesta(Y41eEncuesta y41eEncuesta){
        Y41eEncuesta encuestaCopiar = this.y41eEncuestaDao.copiarEncuesta(y41eEncuesta);
        //copiar bloques
        y41eRelEncuestaBloqueDao.copiarBloques(y41eEncuesta.getIdEncuesta(), encuestaCopiar.getIdEncuesta());
        //copiar preguntas enlazadas
        y41ePreguntaEnlazadaDao.copiarPreguntasEnlazadas(y41eEncuesta.getIdEncuesta(), encuestaCopiar.getIdEncuesta());
        return encuestaCopiar;
    }

    /**
     * Obtiene el excel de la encuesta
     * @param y41eEncuesta
     * @return Y41eExcelModel
     */
    @Override
    public Y41eExcelModel getExcelEncuesta(Y41eEncuesta y41eEncuesta){
        Locale locale = LocaleContextHolder.getLocale();
        //obtener datos
        List<Y41eResultados> encuestas = this.y41eEncuestaDao.getExcelEncuesta(y41eEncuesta);
        final Y41eExcelModel excelModel = new Y41eExcelModel();
        final Y41eExcelHoja excelHoja= new Y41eExcelHoja(this.appMessageSource.getMessage("comun.encuesta", null, locale), 0);

        //imagen
        Y41eExcelCelda imagenCelda = new Y41eExcelCelda();
        imagenCelda.setTipoCelda(Y41eConstants.TIPO_CELDA_IMAGEN);
        imagenCelda.setRutaImagen(Y41eConstants.RUTA_IMAGEN);
        imagenCelda.setPosicionX(0);
        imagenCelda.setPosicionX(0);
        excelHoja.addCelda("imagen", imagenCelda);

        long idBloqueActual=0;
        int posY = Y41eConstants.NUEVE;
        int cont = 1;
        Y41eExcelCelda excelCelda;
        for(int i=0; i<encuestas.size();i++){
            Y41eResultados result = encuestas.get(i);
            if(i==0){
                // encuesta euskera
                excelCelda = new Y41eExcelCelda(result.getEnvio().getEncuesta().getDescPublEu(), Y41eConstants.CERO, Y41eConstants.SEIS, Y41eExcelEstilo.TITLE);
                excelHoja.addCelda("encuestaEu", excelCelda);
                // encuesta castellano
                excelCelda = new Y41eExcelCelda(result.getEnvio().getEncuesta().getDescPublEs(), Y41eConstants.CERO, Y41eConstants.SIETE, Y41eExcelEstilo.TITLE);
                excelHoja.addCelda("encuestaEs", excelCelda);
            }

            if(idBloqueActual!=result.getBloque().getIdBloque()){
                //bloque euskera
                excelCelda = new Y41eExcelCelda(result.getBloque().getDescPublEu(), Y41eConstants.CERO, posY, Y41eExcelEstilo.NEGRITA, Y41eConstants.OCHO);
                if(result.getBloque().getDescPublEu().length()>Y41eConstants.NOVENTAYNUEVE){
                    excelCelda.setAlto(Y41eConstants.EXCEL_HEIGTH);
                }
                excelHoja.addCelda(String.valueOf("bloqueEu"+result.getBloque().getIdBloque()), excelCelda);
                posY++;
                //bloque castellano
                excelCelda = new Y41eExcelCelda(result.getBloque().getDescPublEs(), Y41eConstants.CERO, posY, Y41eExcelEstilo.CONTENT, Y41eConstants.OCHO);
                if(result.getBloque().getDescPublEs().length()>Y41eConstants.NOVENTAYNUEVE){
                    excelCelda.setAlto(Y41eConstants.EXCEL_HEIGTH);
                }
                excelHoja.addCelda(String.valueOf("bloqueEs"+result.getBloque().getIdBloque()), excelCelda);

                posY++;
                posY++;
                cont = 1;
            }
            //pregunta euskera
            if(StringUtils.isNotBlank(result.getPregunta().getDescPublEu())){
                excelCelda = new Y41eExcelCelda(cont+ ". " + result.getPregunta().getDescPublEu(), Y41eConstants.UNO, posY, Y41eExcelEstilo.NEGRITA, Y41eConstants.SIETE);
                if(result.getPregunta().getDescPublEu().length()>Y41eConstants.OCHENTA){
                    excelCelda.setAlto(Y41eConstants.EXCEL_HEIGTH);
                }
                excelHoja.addCelda(String.valueOf("preguntaEu"+result.getBloque().getIdBloque()+result.getPregunta().getIdPregunta()), excelCelda);
                posY++;
            }
            //pregunta castellano
            if(StringUtils.isNotBlank(result.getPregunta().getDescPublEs())){
                excelCelda = new Y41eExcelCelda(result.getPregunta().getDescPublEs(), Y41eConstants.UNO, posY, Y41eExcelEstilo.CONTENT, Y41eConstants.SIETE);
                if(result.getPregunta().getDescPublEs().length()>Y41eConstants.OCHENTA){
                    excelCelda.setAlto(Y41eConstants.EXCEL_HEIGTH);
                }
                excelHoja.addCelda(String.valueOf("preguntaEs"+result.getBloque().getIdBloque()+result.getPregunta().getIdPregunta()), excelCelda);
                posY++;
            }

            //respuestas
            if(StringUtils.isNotBlank(result.getPregunta().getRespuestas())){
                excelCelda = new Y41eExcelCelda(result.getPregunta().getRespuestas(), Y41eConstants.UNO, posY, Y41eExcelEstilo.CONTENT, Y41eConstants.SIETE);
                excelHoja.addCelda(String.valueOf("resultado"+result.getBloque().getIdBloque()+result.getPregunta().getIdPregunta()), excelCelda);
                posY++;
            }else{
                posY++;
            }

            idBloqueActual= result.getBloque().getIdBloque();
            posY++;
            cont++;
        }
        excelModel.getListaHojas().add(excelHoja);
        return excelModel;
    }

    /**
     * Obtiene la encuesta según el parámetro
     * @param param
     * @return
     */
    @Override
    public Y41eEncuesta getEncuestaWsByParam(String param){
        return this.y41eEncuestaDao.getEncuestaWsByParam(param);
    }

    /**
     * Obtiene la encuesta según el parámetro
     * @param param
     * @return
     */
    @Override
    public Y41eEncuesta getEncuestaByParam(String param){
        return this.y41eEncuestaDao.getEncuestaByParam(param);
    }

    /**
     * Cargar la encuesta para mostrar en pantalla
     * @param encuesta Y41eEncuesta
     * @return Y41eEncuesta
     */
    @Override
    public Y41eEncuesta cargarEncuesta(Y41eEncuesta encuesta){
        //obtener los bloques
        encuesta.setListaBloques(this.y41eRelEncuestaBloqueDao.getBloquesWeb(encuesta));
        JQGridRequestDto jqGridRequestDtoRespuestas = new JQGridRequestDto(null, null, "ORDEN_009", "ASC");
        //por cada bloque obtener las preguntas
        for(Y41eBloque bloque:encuesta.getListaBloques()){
            bloque.setListaPreguntas(this.relBloquePreguntaDao.getPreguntasWeb(bloque, encuesta));
            //por cada pregunta obtener los tipos de respuesta
            for(Y41ePregunta pregunta:bloque.getListaPreguntas()){
                Y41eTipoRespuesta tipoRespuesta = new Y41eTipoRespuesta();
                tipoRespuesta.setTipoPregunta(pregunta.getTipoPregunta());
                pregunta.setListRespuestas(this.y41eTipoRespuestaDao.findAll(tipoRespuesta, jqGridRequestDtoRespuestas));
            }
        }
        return encuesta;
    }
}

