package com.ejie.y41e.service;


import com.ejie.y41e.model.Y41eEncuesta;
import com.ejie.y41e.model.excel.Y41eExcelModel;

/**
 * Y41eEncuestaService
 *  
 */

public interface Y41eEncuestaService extends Y41eGenericoService<Y41eEncuesta> {

    /**
     * Comprueba que no existe ninguna encuesta enviada o respondida para el id de la encuesta.
     * 
     * @param idEncuesta Long
     * @return String el area a la que pertence la encuesta 
     *            
     */
    public String validarEncuesta(Long idEncuesta);

    /**
     * Crea una encuesta como copia de la que recibe por parámetro
     * @param y41eEncuesta Y41eEncuesta
     * @return Y41eEncuesta
     */
    public Y41eEncuesta copiarEncuesta(Y41eEncuesta y41eEncuesta);

    /**
     * Obtiene el excel de la encuesta
     * @param y41eEncuesta
     * @return Y41eExcelModel
     */
    public Y41eExcelModel getExcelEncuesta(Y41eEncuesta y41eEncuesta);

    /**
     * Obtiene la encuesta según el parámetro
     * @param param
     * @return
     */
    public Y41eEncuesta getEncuestaWsByParam(String param);

    /**
     * Cargar la encuesta para mostrar en pantalla
     * @param encuesta Y41eEncuesta
     * @return Y41eEncuesta
     */
    public Y41eEncuesta cargarEncuesta(Y41eEncuesta encuesta);

    /**
     * Obtiene la encuesta según el parámetro en la tabla Y41E01T00
     * @param param
     * @return
     */
    public Y41eEncuesta getEncuestaByParam(String param);

}


