package com.ejie.y41e.service;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejie.y41e.dao.Y41eConfiguracionDao;
import com.ejie.y41e.dao.Y41eGenericoDao;
import com.ejie.y41e.model.Y41eConfiguracion;
import com.ejie.y41e.model.Y41eListConfiguracion;

/**
 * Y41eConfiguracionServiceImpl
 *  
 */

@Service(value = "y41eConfiguracionService")
public class Y41eConfiguracionServiceImpl extends Y41eGenericoServiceImpl<Y41eConfiguracion> implements Y41eConfiguracionService {

    @Autowired
    private Y41eConfiguracionDao y41eConfiguracionDao;

    @Override()
    protected Y41eGenericoDao<Y41eConfiguracion> getDao() {
        return this.y41eConfiguracionDao;
    }

    /**
     * Modifica la configuración
     * @param listConfiguracion Y41eListConfiguracion
     */
    @Override
    public void editConfiguracion(Y41eListConfiguracion listConfiguracion){
        for(Y41eConfiguracion config:listConfiguracion.getListConfiguracion()){
            this.y41eConfiguracionDao.update(config);
        }
    }

}

