package com.ejie.y41e.service;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41e.dao.Y41eBloqueDao;
import com.ejie.y41e.dao.Y41eGenericoDao;
import com.ejie.y41e.dao.Y41eRelBloquePreguntaDao;
import com.ejie.y41e.dao.Y41eRelEncuestaBloqueDao;
import com.ejie.y41e.model.Y41eBloque;
import com.ejie.y41e.model.Y41eEncuesta;
import com.ejie.y41e.model.Y41eRelEncuestaBloque;

/**
 * Y41eBloqueServiceImpl
 *  
 */

@Service(value = "y41eBloqueService")
public class Y41eBloqueServiceImpl extends Y41eGenericoServiceImpl<Y41eBloque> implements Y41eBloqueService {

    @Autowired
    private Y41eBloqueDao y41eBloqueDao;
    @Autowired
    private Y41eRelBloquePreguntaDao y41eRelBloquePreguntaDao;
    @Autowired
    private Y41eRelEncuestaBloqueDao y41eRelEncuestaBloqueDao;

    @Override()
    protected Y41eGenericoDao<Y41eBloque> getDao() {
        return this.y41eBloqueDao;
    }

    /**
     * Comprueba que no existe ninguna encuesta enviada o respondida para el id del bloque.
     * @param idBloque Long
     * @return Integer
     */
    @Override
    public Integer validarBloqueEnviada(Long idBloque){
        return this.y41eBloqueDao.validarBloqueEnviada(idBloque);
    }

    /**
     * Comprueba que el bloque pertenece a una encuesta.
     * @param idBloque Long
     * @return Integer
     */
    @Override
    public Integer validarBloqueEncuesta(Long idBloque){
        return this.y41eBloqueDao.validarBloqueEncuesta(idBloque);
    }


    /* (non-Javadoc)
     * @see com.ejie.y41e.service.Y41eGenericoServiceImpl#add(java.lang.Object)
     */
    @Override
    @Transactional(rollbackFor = Throwable.class)
    public Y41eBloque add(Y41eBloque bloque){
        // id del bloque que se está copiando
        Long idBloqueCopiar = bloque.getIdBloque();
        //Añadir bloque
        Y41eBloque bloqueAux = this.y41eBloqueDao.add(bloque);
        //copiar las preguntas relacionadas
        if(idBloqueCopiar!=null && idBloqueCopiar>0){
            //copiar preguntas asociadas
            y41eRelBloquePreguntaDao.copiarPreguntas(bloqueAux.getIdBloque(), idBloqueCopiar);
        }
        return bloque;

    }

    /**
     * Añade el bloque y lo asigna a la encuesta
     * @param y41ebloque Y41eBloque
     * @return
     */
    @Override
    @Transactional(rollbackFor = Throwable.class)
    public void addBloqueEncuesta(Y41eBloque y41ebloque){
        y41eBloqueDao.add(y41ebloque);
        Long orden = y41eRelEncuestaBloqueDao.getSigOrden(y41ebloque.getIdEncuesta());
        Y41eEncuesta encuesta = new Y41eEncuesta(y41ebloque.getIdEncuesta());
        Y41eRelEncuestaBloque relEncuestaBloque = new Y41eRelEncuestaBloque(encuesta, y41ebloque, orden);
        y41eRelEncuestaBloqueDao.add(relEncuestaBloque);
    }

    /**
     * Obtiene los bloques para el suggest
     * @param bloque Y41eBloque
     * @param startsWith boolean
     * @return List<Y41eBloque>
     */
    @Override
    public List<Y41eBloque> findAllSuggest(Y41eBloque bloque, boolean startsWith){
        return this.y41eBloqueDao.findAllSuggest(bloque, startsWith);
    }

}

