package com.ejie.y41e.service;


import java.util.List;

import com.ejie.y41e.model.Y41eBloque;

/**
 * Y41eBloqueService
 *  
 */

public interface Y41eBloqueService extends Y41eGenericoService<Y41eBloque> {

    /**
     * Comprueba que no existe ninguna encuesta enviada o respondida para el id del bloque.
     * @param idBloque Long
     * @return Integer
     */
    public Integer validarBloqueEnviada(Long idBloque);

    /**
     * Comprueba que el bloque pertenece a una encuesta.
     * @param idBloque Long
     * @return Integer
     */
    public Integer validarBloqueEncuesta(Long idBloque);

    /**
     * Añade el bloque y lo asigna a la encuesta
     * @param y41ebloque Y41eBloque
     * @return
     */
    public void addBloqueEncuesta(Y41eBloque y41ebloque);

    /**
     * Obtiene los bloques para el suggest
     * @param bloque Y41eBloque
     * @param startsWith boolean
     * @return List<Y41eBloque>
     */
    public List<Y41eBloque> findAllSuggest(Y41eBloque bloque, boolean startsWith);

}


