package com.ejie.y41e.model.excel;

import java.util.LinkedHashMap;
import java.util.Map;

import org.apache.commons.lang.StringUtils;

import com.ejie.y41e.common.Y41eConstants;

/**
 *  
 * 
 */
public final class Y41eExcelHoja {
    private final Map<String, Y41eExcelCelda> celdas = new LinkedHashMap<String, Y41eExcelCelda>();
    private String nombreHoja = "";
    private int numeroHoja = 0;

    /**
     * @param nombreHoja
     *            String
     * @param numeroHoja
     *            int
     */
    public Y41eExcelHoja(String nombreHoja, int numeroHoja) {
        this.nombreHoja = StringUtils.substring(nombreHoja, 0, Y41eConstants.TREINTAYUNO);
        this.numeroHoja = numeroHoja;
    }

    /**
     * @return String
     */
    public Map<String, Y41eExcelCelda> getParametros() {
        return this.celdas;
    }

    /**
     * @param key
     *            String
     * @param celda
     *            Aa79bExcelCelda
     */
    public void addCelda(String key, Y41eExcelCelda celda) {
        this.celdas.put(key, (celda != null) ? celda : new Y41eExcelCelda());
    }

    /**
     * @return String
     */
    public String getNombreHoja() {
        return this.nombreHoja;
    }

    /**
     * @param nombreHoja
     *            String
     */
    public void setNombreHoja(String nombreHoja) {
        this.nombreHoja = nombreHoja;
    }

    /**
     * @return int
     */
    public int getNumeroHoja() {
        return this.numeroHoja;
    }

    /**
     * @param numeroHoja
     *            int
     */
    public void setNumeroHoja(int numeroHoja) {
        this.numeroHoja = numeroHoja;
    }

}
