package com.ejie.y41e.model.excel;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

/**
 *  
 *
 */
public final class Y41eExcelEstilo {
    /**
     * STYLES: Map.
     */
    private static final Map<String, Y41eExcelEstilo> STYLES = new HashMap<String, Y41eExcelEstilo>();
    /**
     * CONTENT: String.
     */
    public static final String CONTENT = "CONTENT";
    /**
     * TITLE: String.
     */
    public static final String TITLE = "TITLE";
    /**
     * NEGRITA: String.
     */
    public static final String NEGRITA = "NEGRITA";

    static {
        // DEFAULT
        final Y41eExcelEstilo content = new Y41eExcelEstilo();
        Y41eExcelEstilo.STYLES.put(Y41eExcelEstilo.CONTENT, content);

        // NEGRITA
        final Y41eExcelEstilo negrita = new Y41eExcelEstilo();
        negrita.setFuente(Y41eExcelFuentes.BLACK_ARIAL_10_BOLD);
        Y41eExcelEstilo.STYLES.put(Y41eExcelEstilo.NEGRITA, negrita);

        // TITLE
        final Y41eExcelEstilo title = new Y41eExcelEstilo();
        title.setFuente(Y41eExcelFuentes.BLACK_ARIAL_24_BOLD);
        Y41eExcelEstilo.STYLES.put(Y41eExcelEstilo.TITLE, title);
    }

    /**
     * Este metodo sirve para obtener el estilo de la clave.
     * 
     * @param libro
     *            XSSFWorkbook
     * @param key
     *            String
     * @return XSSFCellStyle
     */
    public static XSSFCellStyle getEstilo(XSSFWorkbook libro, String key) {
        if (Y41eExcelEstilo.STYLES.containsKey(key)) {
            final XSSFCellStyle celdaEstilo = libro.createCellStyle();
            Y41eExcelEstilo estilo = Y41eExcelEstilo.STYLES.get(key);
            celdaEstilo.setAlignment(estilo.getAlignment());
            celdaEstilo.setVerticalAlignment(estilo.getVerticalAlignment());
            celdaEstilo.setBorderBottom(estilo.getBorderBottom());
            estilo.setBorderTop(estilo.getBorderTop());
            celdaEstilo.setBorderRight(estilo.getBorderRight());
            celdaEstilo.setBorderLeft(estilo.getBorderLeft());
            celdaEstilo.setBottomBorderColor(estilo.getBottomBorderColor());
            celdaEstilo.setTopBorderColor(estilo.getTopBoderColor());
            celdaEstilo.setRightBorderColor(estilo.getRightBorderColor());
            celdaEstilo.setLeftBorderColor(estilo.getLeftBorderColor());
            celdaEstilo.setFillForegroundColor(estilo.getFillForegroundColor());
            celdaEstilo.setDataFormat(estilo.getDataFormat());
            celdaEstilo.setFillPattern(estilo.getFillPattern());
            celdaEstilo.setFillBackgroundColor(estilo.getBackgroundColor());
            celdaEstilo.setLocked(estilo.isLocked());

            final XSSFFont fuenteFont = libro.createFont();
            final Y41eExcelFuentes fuente = Y41eExcelFuentes.getFuente(estilo.getFuente());
            fuenteFont.setColor(fuente.getColor());
            fuenteFont.setItalic(fuente.isItalic());
            fuenteFont.setBoldweight(fuente.getBoldWeight());
            fuenteFont.setFontHeightInPoints(fuente.getFontHeightInPoints());
            fuenteFont.setFontName(fuente.getFontName());
            fuenteFont.setUnderline(fuente.getUnderline());
            celdaEstilo.setFont(fuenteFont);
            return celdaEstilo;
        } else {
            return libro.createCellStyle();
        }
    }

    /**
     * Este metodo sirve para obtener las claves de los estilos almacenadas.
     * 
     * @return Los estilos almacenadas
     */
    public static Set<String> getKeys() {
        return Y41eExcelEstilo.STYLES.keySet();
    }

    /**
     * alignment: short.
     */
    private short alignment = HSSFCellStyle.ALIGN_GENERAL;
    /**
     * verticalAlignment: short.
     */
    private short verticalAlignment = HSSFCellStyle.ALIGN_GENERAL;
    /**
     * borderTop: short.
     */
    private short borderTop = HSSFCellStyle.BORDER_NONE;
    /**
     * borderBottom: short.
     */
    private short borderBottom = HSSFCellStyle.BORDER_NONE;
    /**
     * borderRight: short.
     */
    private short borderRight = HSSFCellStyle.BORDER_NONE;
    /**
     * borderLeft: short.
     */
    private short borderLeft = HSSFCellStyle.BORDER_NONE;
    /**
     * topBoderColor: short.
     */
    private short topBoderColor = HSSFColor.WHITE.index;
    /**
     * bottomBorderColor: short.
     */
    private short bottomBorderColor = HSSFColor.WHITE.index;
    /**
     * rightBorderColor: short.
     */
    private short rightBorderColor = HSSFColor.WHITE.index;
    /**
     * leftBorderColor: short.
     */
    private short leftBorderColor = HSSFColor.WHITE.index;
    /**
     * fillForegroundColor: short.
     */
    private short fillForegroundColor = HSSFColor.WHITE.index;
    /**
     * dataFormat: short.
     */
    private short dataFormat = HSSFDataFormat.getBuiltinFormat("@");
    /**
     * fillPattern: short.
     */
    private short fillPattern = HSSFCellStyle.NO_FILL;
    /**
     * backgroundColor: short.
     */
    private short backgroundColor = HSSFColor.WHITE.index;
    /**
     * locked: boolean.
     */
    private boolean locked = false;
    /**
     * fuente: String.
     */
    private String fuente = Y41eExcelFuentes.BLACK_ARIAL_10;

    /**
     * El metodo constructor.
     */
    public Y41eExcelEstilo() {
        // Empty constructor
    }

    /**
     * @return the alignment
     */
    public short getAlignment() {
        return this.alignment;
    }

    /**
     * @param alignment
     *            the alignment to set
     */
    public void setAlignment(short alignment) {
        this.alignment = alignment;
    }

    /**
     * @return the verticalAlignment
     */
    public short getVerticalAlignment() {
        return this.verticalAlignment;
    }

    /**
     * @param verticalAlignment
     *            the verticalAlignment to set
     */
    public void setVerticalAlignment(short verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
    }

    /**
     * @return the borderTop
     */
    public short getBorderTop() {
        return this.borderTop;
    }

    /**
     * @param borderTop
     *            the borderTop to set
     */
    public void setBorderTop(short borderTop) {
        this.borderTop = borderTop;
    }

    /**
     * @return the borderBottom
     */
    public short getBorderBottom() {
        return this.borderBottom;
    }

    /**
     * @param borderBottom
     *            the borderBottom to set
     */
    public void setBorderBottom(short borderBottom) {
        this.borderBottom = borderBottom;
    }

    /**
     * @return the borderRight
     */
    public short getBorderRight() {
        return this.borderRight;
    }

    /**
     * @param borderRight
     *            the borderRight to set
     */
    public void setBorderRight(short borderRight) {
        this.borderRight = borderRight;
    }

    /**
     * @return the borderLeft
     */
    public short getBorderLeft() {
        return this.borderLeft;
    }

    /**
     * @param borderLeft
     *            the borderLeft to set
     */
    public void setBorderLeft(short borderLeft) {
        this.borderLeft = borderLeft;
    }

    /**
     * @return the topBoderColor
     */
    public short getTopBoderColor() {
        return this.topBoderColor;
    }

    /**
     * @param topBoderColor
     *            the topBoderColor to set
     */
    public void setTopBoderColor(short topBoderColor) {
        this.topBoderColor = topBoderColor;
    }

    /**
     * @return the bottomBorderColor
     */
    public short getBottomBorderColor() {
        return this.bottomBorderColor;
    }

    /**
     * @param bottomBorderColor
     *            the bottomBorderColor to set
     */
    public void setBottomBorderColor(short bottomBorderColor) {
        this.bottomBorderColor = bottomBorderColor;
    }

    /**
     * @return the rightBorderColor
     */
    public short getRightBorderColor() {
        return this.rightBorderColor;
    }

    /**
     * @param rightBorderColor
     *            the rightBorderColor to set
     */
    public void setRightBorderColor(short rightBorderColor) {
        this.rightBorderColor = rightBorderColor;
    }

    /**
     * @return the leftBorderColor
     */
    public short getLeftBorderColor() {
        return this.leftBorderColor;
    }

    /**
     * @param leftBorderColor
     *            the leftBorderColor to set
     */
    public void setLeftBorderColor(short leftBorderColor) {
        this.leftBorderColor = leftBorderColor;
    }

    /**
     * @return the fillForegroundColor
     */
    public short getFillForegroundColor() {
        return this.fillForegroundColor;
    }

    /**
     * @param fillForegroundColor
     *            the fillForegroundColor to set
     */
    public void setFillForegroundColor(short fillForegroundColor) {
        this.fillForegroundColor = fillForegroundColor;
    }

    /**
     * @return the dataFormat
     */
    public short getDataFormat() {
        return this.dataFormat;
    }

    /**
     * @param dataFormat
     *            the dataFormat to set
     */
    public void setDataFormat(short dataFormat) {
        this.dataFormat = dataFormat;
    }

    /**
     * @return the fillPattern
     */
    public short getFillPattern() {
        return this.fillPattern;
    }

    /**
     * @param fillPattern
     *            the fillPattern to set
     */
    public void setFillPattern(short fillPattern) {
        this.fillPattern = fillPattern;
    }

    /**
     * @return the locked
     */
    public boolean isLocked() {
        return this.locked;
    }

    /**
     * @param locked
     *            the locked to set
     */
    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    /**
     * @return the fuente
     */
    public String getFuente() {
        return this.fuente;
    }

    /**
     * @param fuente
     *            the fuente to set
     */
    public void setFuente(String fuente) {
        this.fuente = fuente;
    }

    /**
     * Este metodo sirve para obetener el valor de la propiedad backgroundColor.
     * 
     *  
     * @return El valor de backgroundColor
     */
    public short getBackgroundColor() {
        return this.backgroundColor;
    }

    /**
     * Este metodo sirve para fijar el valor de la propiedad backgroundColor.
     * 
     *  
     * @param backgroundColor
     *            El nuevo valor de backgroundColor
     */
    public void setBackgroundColor(short backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

}
