package com.ejie.y41e.model.excel;

import com.ejie.y41e.common.Y41eConstants;

/**
 *  
 *
 */
public class Y41eExcelCelda implements java.io.Serializable {

    private static final long serialVersionUID = 1L;
    /**
     * El dato a mostrar dato String
     */
    private String dato = "";
    /**
     * Posición X de la celda posicionX String
     */
    private int posicionX = 0;
    /**
     * Posición Y de la celda posicionY String
     */
    private int posicionY = 0;

    /**
     * ancho
     */
    private int anchoMerge = 0;

    /**
     * alto
     */
    private int alto = 0;

    /**
     * Estilo de la celda de la celda estilo String
     */
    private String estilo = "";

    /**
     * Indica el tipo de celda (imagen o texto) estilo String
     */
    private String tipoCelda = Y41eConstants.TIPO_CELDA_TEXTO;

    /**
     * nombreImagen String
     */
    private String rutaImagen = "";

    /**
     * 
     */
    public Y41eExcelCelda() {
        //Constructor vacío
    }

    /**
     * @param dato
     *            String
     */
    public Y41eExcelCelda(String dato) {
        this.dato = dato;
    }

    /**
     * @param dato
     *            String
     * @param posicionX
     *            int
     * @param posicionY
     *            int
     * @param estilo
     *            String
     */
    public Y41eExcelCelda(String dato, int posicionX, int posicionY, String estilo) {
        this.dato = dato;
        this.posicionX = posicionX;
        this.posicionY = posicionY;
        this.estilo = estilo;
    }



    /**
     * @param dato
     * @param posicionX
     * @param posicionY
     * @param anchoMerge
     * @param alto
     * @param estilo
     */
    public Y41eExcelCelda(String dato, int posicionX, int posicionY, String estilo, int anchoMerge) {
        this.dato = dato;
        this.posicionX = posicionX;
        this.posicionY = posicionY;
        this.estilo = estilo;
        this.anchoMerge = anchoMerge;
    }

    /**
     * @return String
     */
    public String getDato() {
        return this.dato;
    }

    /**
     * @param dato
     *            String
     */
    public void setDato(String dato) {
        this.dato = dato;
    }

    /**
     * @return int
     */
    public int getPosicionX() {
        return this.posicionX;
    }

    /**
     * @param posicionX
     *            int
     */
    public void setPosicionX(int posicionX) {
        this.posicionX = posicionX;
    }

    /**
     * @return int
     */
    public int getPosicionY() {
        return this.posicionY;
    }

    /**
     * @param posicionY
     *            int
     */
    public void setPosicionY(int posicionY) {
        this.posicionY = posicionY;
    }

    /**
     * @return String
     */
    public String getEstilo() {
        return this.estilo;
    }

    /**
     * @param estilo
     *            String
     */
    public void setEstilo(String estilo) {
        this.estilo = estilo;
    }

    /**
     * @return String
     */
    public String getTipoCelda() {
        return this.tipoCelda;
    }

    /**
     * @param tipoCelda
     *            String
     */
    public void setTipoCelda(String tipoCelda) {
        this.tipoCelda = tipoCelda;
    }

    /**
     * @return String
     */
    public String getRutaImagen() {
        return this.rutaImagen;
    }

    /**
     * @param rutaImagen
     *            String
     */
    public void setRutaImagen(String rutaImagen) {
        this.rutaImagen = rutaImagen;
    }

    /**
     * @return the anchoMerge
     */
    public int getAnchoMerge() {
        return anchoMerge;
    }

    /**
     * @param anchoMerge the anchoMerge to set
     */
    public void setAnchoMerge(int anchoMerge) {
        this.anchoMerge = anchoMerge;
    }

    /**
     * @return the alto
     */
    public int getAlto() {
        return alto;
    }

    /**
     * @param alto the alto to set
     */
    public void setAlto(int alto) {
        this.alto = alto;
    }

}
