package com.ejie.y41e.model;


import java.util.ArrayList;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnore;

/**
 * Y41eTipoRespuesta
 *  
 */

public class Y41eTipoRespuesta extends Y41eDescripcion implements java.io.Serializable {

    private static final long serialVersionUID = 1L;
    private Long idTipoRespuesta;
    private Y41eTipoPregunta tipoPregunta;
    private Long orden;
    private List<Y41eResultados> resultados = new ArrayList<Y41eResultados>();

    /** 
     * Method 'Y41eTipoRespuesta'.
     */
    public Y41eTipoRespuesta() {
        //constructor
    }

    /** 
     * Method 'Y41eTipoRespuesta'.
     * @param idTipoRespuesta Long
     */    
    public Y41eTipoRespuesta(Long idTipoRespuesta) {
        this.idTipoRespuesta = idTipoRespuesta;
    }

    /**
     * Method 'getIdTipoRespuesta'.
     *
     * @return Long
     */
    public Long getIdTipoRespuesta() {
        return this.idTipoRespuesta;
    }

    /**
     * Method 'setIdTipoRespuesta'.
     *
     * @param idTipoRespuesta Long
     * @return
     */
    public void setIdTipoRespuesta(Long idTipoRespuesta) {
        this.idTipoRespuesta = idTipoRespuesta;
    }
    /**
     * Method 'getTipoPregunta'.
     *
     * @return tipoPregunta
     */
    @JsonIgnore
    public Y41eTipoPregunta getTipoPregunta() {
        if(this.tipoPregunta==null){
            this.tipoPregunta = new Y41eTipoPregunta();
        }
        return this.tipoPregunta;
    }

    /**
     * Method 'setTipoPregunta'.
     *
     * @param tipoPregunta Y41eTipoPregunta
     * @return
     */
    public void setTipoPregunta(Y41eTipoPregunta tipoPregunta) {
        this.tipoPregunta = tipoPregunta;
    }

    /**
     * Method 'getOrden'.
     *
     * @return Long
     */
    public Long getOrden() {
        return this.orden;
    }

    /**
     * Method 'setOrden'.
     *
     * @param orden Long
     * @return
     */
    public void setOrden(Long orden) {
        this.orden = orden;
    }

    /**
     * Method 'getResultados'.
     *
     * @return List
     */
    @JsonIgnore
    public List<Y41eResultados> getResultados() {
        return this.resultados;
    }

    /**
     * Method 'setResultados'.
     *
     * @param resultadoses List
     * @return
     */
    public void setResultados(List<Y41eResultados> resultados) {
        this.resultados = resultados;
    }
}

