package com.ejie.y41e.model;


import java.util.ArrayList;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnore;

/**
 * Y41eTipoPregunta
 *  
 */

public class Y41eTipoPregunta extends Y41eDescripcion implements java.io.Serializable {

    private static final long serialVersionUID = 1L;
    private Long idTipoPregunta;
    private String tipoGrafico;
    private List<Y41eTipoRespuesta> tipoRespuestas = new ArrayList<Y41eTipoRespuesta>();
    private List<Y41ePregunta> preguntas = new ArrayList<Y41ePregunta>();
    private List<Y41eResultados> resultados = new ArrayList<Y41eResultados>();

    /** 
     * Method 'Y41eTipoPregunta'.
     */
    public Y41eTipoPregunta() {
        //constructor
    }

    /** 
     * Method 'Y41eTipoPregunta'.
     * @param idTipoPregunta Long
     */    
    public Y41eTipoPregunta(Long idTipoPregunta) {
        this.idTipoPregunta = idTipoPregunta;
    }


    /** 
     * Method 'Y41eTipoPregunta'.
     * @param idTipoPregunta Long
     * @param descEs String
     * @param descEu String
     * @param activa String
     */
    public Y41eTipoPregunta(Long idTipoPregunta, String descEs, String descEu, String activa ) {
        super(descEs, descEu, activa);
        this.idTipoPregunta = idTipoPregunta;
    }

    /**
     * Method 'getIdTipoPregunta'.
     *
     * @return Long
     */
    public Long getIdTipoPregunta() {
        return this.idTipoPregunta;
    }

    /**
     * Method 'setIdTipoPregunta'.
     *
     * @param idTipoPregunta Long
     * @return
     */
    public void setIdTipoPregunta(Long idTipoPregunta) {
        this.idTipoPregunta = idTipoPregunta;
    }

    /**
     * Method 'getTipoRespuestas'.
     *
     * @return List
     */
    @JsonIgnore
    public List<Y41eTipoRespuesta> getTipoRespuestas() {
        return this.tipoRespuestas;
    }

    /**
     * Method 'setTipoRespuestas'.
     *
     * @param tipoRespuestas List
     * @return
     */
    public void setTipoRespuestas(List<Y41eTipoRespuesta> tipoRespuestas) {
        this.tipoRespuestas = tipoRespuestas;
    }

    /**
     * @return the preguntas
     */
    @JsonIgnore
    public List<Y41ePregunta> getPreguntas() {
        return preguntas;
    }

    /**
     * Method 'setPreguntas'.
     *
     * @param preguntas List
     * @return
     */
    public void setPreguntas(List<Y41ePregunta> preguntas) {
        this.preguntas = preguntas;
    }

    /**
     * @return the resultados
     */
    @JsonIgnore
    public List<Y41eResultados> getResultados() {
        return resultados;
    }

    /**
     * Method 'setResultados'.
     *
     * @param resultados List
     * @return
     */
    public void setResultados(List<Y41eResultados> resultados) {
        this.resultados = resultados;
    }

    /**
     * @return the tipoGrafico
     */
    public String getTipoGrafico() {
        return tipoGrafico;
    }

    /**
     * @param tipoGrafico the tipoGrafico to set
     */
    public void setTipoGrafico(String tipoGrafico) {
        this.tipoGrafico = tipoGrafico;
    }
}

