package com.ejie.y41e.model;


import com.fasterxml.jackson.annotation.JsonIgnore;

/**
 * Y41eResultados
 *  
 */

public class Y41eResultados  implements java.io.Serializable {

    private static final long serialVersionUID = 1L;
    private Y41eEnvio envio;
    private Y41ePregunta pregunta;
    private Y41eBloque bloque;
    private Y41eTipoRespuesta respuesta;
    private String texto;
    private Long numRespuestas;
    private Long porcentaje;

    /** 
     * Method 'Y41eResultados'.
     */
    public Y41eResultados() {
        //constructor
    }

    /** 
     * Method 'Resultados'.
     * @param envio Y41eEnvio
     */    
    public Y41eResultados(Y41eEnvio envio) {
        this.envio = envio;
    }



    /** 
     * Method 'Resultados'.
     * @param envio Y41eEnvio
     * @param texto String
     * @param pregunta Y41ePregunta
     * @param respuesta Y41eTipoRespuesta
     */
    public Y41eResultados(Y41eEnvio envio, String texto, Y41ePregunta pregunta, Y41eTipoRespuesta respuesta) {

        this.envio = envio;
        this.pregunta = pregunta;
        this.respuesta = respuesta;
        this.texto = texto;
    }

    /**
     * Method 'getEnvio'.
     *
     * @return Y41eEnvio
     */
    public Y41eEnvio getEnvio() {
        if(this.envio==null){
            this.envio = new Y41eEnvio();
        }
        return this.envio;
    }

    /**
     * Method 'setEnvio'.
     *
     * @param envio Y41eEnvio
     * @return
     */

    public void setEnvio(Y41eEnvio envio) {
        this.envio = envio;
    }
    /**
     * Method 'getPregunta'.
     *
     * @return Y41ePregunta
     */
    @JsonIgnore
    public Y41ePregunta getPregunta() {
        if(this.pregunta==null){
            this.pregunta = new Y41ePregunta();
        }
        return this.pregunta;
    }

    /**
     * Method 'setPregunta'.
     *
     * @param pregunta Y41ePregunta
     * @return
     */
    public void setPregunta(Y41ePregunta pregunta) {
        this.pregunta = pregunta;
    }

    /**
     * Method 'setBloque'.
     *
     * @param bloque Y41eBloque
     * @return
     */
    public void setBloque(Y41eBloque bloque) {
        this.bloque = bloque;
    }

    /**
     * Method 'getBloque'.
     *
     * @return Y41eBloque
     */
    @JsonIgnore
    public Y41eBloque getBloque() {
        if(this.bloque==null){
            this.bloque = new Y41eBloque();
        }
        return this.bloque;
    }

    /**
     * Method 'getRespuesta'.
     *
     * @return Y41eTipoRespuesta
     */
    public Y41eTipoRespuesta getRespuesta() {
        if(this.respuesta==null){
            this.respuesta = new Y41eTipoRespuesta();
        }
        return this.respuesta;
    }

    /**
     * Method 'setRespuesta'.
     *
     * @param respuesta Y41eTipoRespuesta
     * @return
     */
    public void setRespuesta(Y41eTipoRespuesta respuesta) {
        this.respuesta = respuesta;
    }
    /**
     * Method 'getTexto'.
     *
     * @return String
     */
    public String getTexto() {
        return this.texto;
    }

    /**
     * Method 'setTexto'.
     *
     * @param texto String
     * @return
     */
    public void setTexto(String texto) {
        this.texto = texto;
    }

    /**
     * @return the numRespuestas
     */
    public Long getNumRespuestas() {
        return numRespuestas;
    }

    /**
     * @param numRespuestas the numRespuestas to set
     */
    public void setNumRespuestas(Long numRespuestas) {
        this.numRespuestas = numRespuestas;
    }

    /**
     * @return the porcentaje
     */
    public Long getPorcentaje() {
        return porcentaje;
    }

    /**
     * @param porcentaje the porcentaje to set
     */
    public void setPorcentaje(Long porcentaje) {
        this.porcentaje = porcentaje;
    }

}

