package com.ejie.y41e.model;

import com.ejie.y41e.common.Y41eConstants;

/**
 * Y41eRelEncuestaBloque
 *  
 */

public class Y41eRelEncuestaBloque  implements java.io.Serializable {

    private static final long serialVersionUID = 1L;
    private Y41eEncuesta encuesta;
    private Y41eBloque bloque;
    private Long ordenBloq;

    /** 
     * Method 'Y41eRelEncuestaBloque'.
     */
    public Y41eRelEncuestaBloque() {
        //constructor
    }


    /** 
     * Method 'RelEncuestaBloque'.
     * @param encuesta Y41eEncuesta
     * @param bloque Y41eBloque
     */    
    public Y41eRelEncuestaBloque(Y41eEncuesta encuesta, Y41eBloque bloque) {
        this.encuesta = encuesta;
        this.bloque = bloque;
    }


    /** 
     * Method 'RelEncuestaBloque'.
     * @param encuesta Y41eEncuesta
     * @param bloque Y41eBloque
     * @param ordenBloq Long
     */
    public Y41eRelEncuestaBloque(Y41eEncuesta encuesta, Y41eBloque bloque, Long ordenBloq  ) {

        this.encuesta = encuesta;
        this.bloque = bloque;
        this.ordenBloq = ordenBloq;
    }

    /**
     * Method 'getEncuesta'.
     *
     * @return Y41eEncuesta
     */
    public Y41eEncuesta getEncuesta() {
        if(this.encuesta==null){
            this.encuesta = new Y41eEncuesta();
        }
        return this.encuesta;
    }

    /**
     * Method 'setEncuesta'.
     *
     * @param encuesta Y41eEncuesta
     * @return
     */

    public void setEncuesta(Y41eEncuesta encuesta) {
        this.encuesta = encuesta;
    }
    /**
     * Method 'getBloque'.
     *
     * @return Y41eBloque
     */
    public Y41eBloque getBloque() {
        if(this.bloque==null){
            this.bloque = new Y41eBloque();
        }
        return this.bloque;
    }

    /**
     * Method 'setY41eBloque'.
     *
     * @param bloque Y41eBloque
     * @return
     */

    public void setY41eBloque(Y41eBloque bloque) {
        this.bloque = bloque;
    }
    /**
     * Method 'getOrdenBloq'.
     *
     * @return Long
     */


    public Long getOrdenBloq() {
        return this.ordenBloq;
    }

    /**
     * Method 'setOrdenBloq'.
     *
     * @param ordenBloq Long
     * @return
     */

    public void setOrdenBloq(Long ordenBloq) {
        this.ordenBloq = ordenBloq;
    }

    /**
     * @return String
     */
    public String getCodigoPK(){
        StringBuilder codigoPK = new StringBuilder()
                .append(this.getEncuesta().getIdEncuesta())
                .append(Y41eConstants.SEPARADOR_OPTION)
                .append(this.getBloque().getIdBloque());
        return codigoPK.toString();
    }

}

