package com.ejie.y41e.model;

import com.ejie.y41e.common.Y41eConstants;

/**
 * Y41eRelBloquePregunta
 *  
 */

public class Y41eRelBloquePregunta  implements java.io.Serializable {

    private static final long serialVersionUID = 1L;
    private Y41eBloque bloque;
    private Y41ePregunta pregunta;
    private Long ordenPreg;

    /** 
     * Method 'Y41eRelBloquePregunta'.
     */
    public Y41eRelBloquePregunta() {
        //constructor
    }

    /** 
     * Method 'RelBloquePregunta'.
     * @param bloque Y41eBloque
     * @param pregunta Y41ePregunta
     */    
    public Y41eRelBloquePregunta(Y41eBloque bloque, Y41ePregunta pregunta) {
        this.bloque = bloque;
        this.pregunta = pregunta;
    }


    /** 
     * Method 'RelBloquePregunta'.
     * @param bloque Y41eBloque
     * @param pregunta Y41ePregunta
     * @param ordenPreg Long
     */
    public Y41eRelBloquePregunta(Y41eBloque bloque, Y41ePregunta pregunta, Long ordenPreg  ) {

        this.bloque = bloque;
        this.pregunta = pregunta;
        this.ordenPreg = ordenPreg;
    }

    /**
     * Method 'getBloque'.
     *
     * @return Y41eBloque
     */
    public Y41eBloque getBloque() {
        if(this.bloque==null){
            this.bloque = new Y41eBloque();
        }
        return this.bloque;
    }

    /**
     * Method 'setBloque'.
     *
     * @param bloque Y41eBloque
     * @return
     */

    public void setBloque(Y41eBloque bloque) {
        this.bloque = bloque;
    }
    /**
     * Method 'getPregunta'.
     *
     * @return Y41ePregunta
     */
    public Y41ePregunta getPregunta() {
        if(this.pregunta==null){
            this.pregunta = new Y41ePregunta();
        }
        return this.pregunta;
    }

    /**
     * Method 'setPregunta'.
     *
     * @param pregunta Y41ePregunta
     * @return
     */

    public void setPregunta(Y41ePregunta pregunta) {
        this.pregunta = pregunta;
    }
    /**
     * Method 'getOrdenPreg'.
     *
     * @return Long
     */
    public Long getOrdenPreg() {
        return this.ordenPreg;
    }

    /**
     * Method 'setOrdenPreg'.
     *
     * @param ordenPreg Long
     * @return
     */

    public void setOrdenPreg(Long ordenPreg) {
        this.ordenPreg = ordenPreg;
    }

    /**
     * @return String
     */
    public String getCodigoPK(){
        StringBuilder codigoPK = new StringBuilder()
                .append(this.getBloque().getIdBloque())
                .append(Y41eConstants.SEPARADOR_OPTION)
                .append(this.getPregunta().getIdPregunta());
        return codigoPK.toString();
    }
}

