package com.ejie.y41e.model;

import com.ejie.y41e.common.Y41eConstants;

/**
 * Y41ePreguntaEnlazada
 *  
 */

public class Y41ePreguntaEnlazada extends Y41eDetalle implements java.io.Serializable {

    private static final long serialVersionUID = 1L;
    private Long idEncuesta;
    private Long idBloque;
    private Long idPregunta;
    private Long idEnlazada;
    private String tipo;
    private String seleccionada;


    /** 
     * Method 'Y41ePreguntaEnlazada'.
     */
    public Y41ePreguntaEnlazada() {
        //constructor
    }

    /**
     * @param idEncuesta
     * @param idBloque
     */
    public Y41ePreguntaEnlazada(Long idEncuesta, Long idBloque) {
        super();
        this.idEncuesta = idEncuesta;
        this.idBloque = idBloque;
    }

    /**
     * @param idEncuesta Long
     * @param idBloque Long
     * @param idPregunta Long
     */
    public Y41ePreguntaEnlazada(Long idEncuesta, Long idBloque, Long idPregunta) {
        this.idEncuesta = idEncuesta;
        this.idBloque = idBloque;
        this.idPregunta = idPregunta;
    }

    /**
     * @return the idEncuesta
     */
    public Long getIdEncuesta() {
        return idEncuesta;
    }

    /**
     * @param idEncuesta the idEncuesta to set
     */
    public void setIdEncuesta(Long idEncuesta) {
        this.idEncuesta = idEncuesta;
    }

    /**
     * @return the idBloque
     */
    public Long getIdBloque() {
        return idBloque;
    }

    /**
     * @param idBloque the idBloque to set
     */
    public void setIdBloque(Long idBloque) {
        this.idBloque = idBloque;
    }

    /**
     * @return the idPregunta
     */
    public Long getIdPregunta() {
        return idPregunta;
    }

    /**
     * @param idPregunta the idPregunta to set
     */
    public void setIdPregunta(Long idPregunta) {
        this.idPregunta = idPregunta;
    }

    /**
     * @return the idEnlazada
     */
    public Long getIdEnlazada() {
        return idEnlazada;
    }

    /**
     * @param idEnlazada the idEnlazada to set
     */
    public void setIdEnlazada(Long idEnlazada) {
        this.idEnlazada = idEnlazada;
    }

    /**
     * @return the tipo
     */
    public String getTipo() {
        return tipo;
    }

    /**
     * @param tipo the tipo to set
     */
    public void setTipo(String tipo) {
        this.tipo = tipo;
    }

    /**
     * @return the seleccionada
     */
    public String getSeleccionada() {
        return seleccionada;
    }

    /**
     * @param seleccionada the seleccionada to set
     */
    public void setSeleccionada(String seleccionada) {
        this.seleccionada = seleccionada;
    }

    /**
     * @return String
     */
    public String getCodigoPK(){
        StringBuilder codigoPK = new StringBuilder()
                .append(this.idEncuesta)
                .append(Y41eConstants.SEPARADOR_OPTION)
                .append(this.idBloque)
                .append(Y41eConstants.SEPARADOR_OPTION)
                .append(this.idPregunta)
                .append(Y41eConstants.SEPARADOR_OPTION)
                .append(this.idEnlazada)
                .append(Y41eConstants.SEPARADOR_OPTION)
                .append(tipo);
        return codigoPK.toString();
    }

}
