package com.ejie.y41e.model;


import java.util.ArrayList;
import java.util.List;

/**
 * Y41ePregunta
 *  
 */

public class Y41ePregunta extends Y41eDetalle implements java.io.Serializable {

    private static final long serialVersionUID = 1L;
    private Long idPregunta;
    private Y41eTipoPregunta tipoPregunta;
    private String obligatorio;
    private List<Y41eTipoRespuesta> listRespuestas = new ArrayList<Y41eTipoRespuesta>();
    private Long idBloque;
    private Boolean selectedAll;
    private List<String> selectedIds;
    private String aviso;
    private String respuestasAviso;
    private Y41eResultados resultado;
    private String isEnlazada;
    private String isBloqueEnlazada;
    private String hasEnlazada;
    private Long idPreguntaPadre;
    private List<Y41ePreguntaEnlazada> listaEnlazadas = new ArrayList<Y41ePreguntaEnlazada>();
    private String respuestas;

    /** 
     * Method 'Y41ePregunta'.
     */
    public Y41ePregunta() {
        //constructor
    }

    /** 
     * Method 'Y41ePregunta'.
     * @param idPregunta Long
     */    
    public Y41ePregunta(Long idPregunta) {
        this.idPregunta = idPregunta;
    }

    /** 
     * Method 'Y41ePregunta'.
     * @param idPregunta Long
     * @param descPublEs String
     * @param descPublEu String
     */    
    public Y41ePregunta(Long idPregunta, String descPublEs, String descPublEu) {
        super(descPublEs, descPublEu, null, null);
        this.idPregunta = idPregunta;
    }


    /**
     * Method 'getIdPregunta'.
     *
     * @return Long
     */
    public Long getIdPregunta() {
        return this.idPregunta;
    }

    /**
     * Method 'setIdPregunta'.
     *
     * @param idPregunta Long
     * @return
     */
    public void setIdPregunta(Long idPregunta) {
        this.idPregunta = idPregunta;
    }
    /**
     * Method 'getTipoPregunta'.
     *
     * @return tipoPregunta
     */
    public Y41eTipoPregunta getTipoPregunta() {
        if(this.tipoPregunta==null){
            this.tipoPregunta = new Y41eTipoPregunta();
        }
        return this.tipoPregunta;
    }

    /**
     * Method 'setTipoPregunta'.
     *
     * @param tipoPregunta Y41eTipoPregunta
     * @return
     */
    public void setTipoPregunta(Y41eTipoPregunta tipoPregunta) {
        this.tipoPregunta = tipoPregunta;
    }

    /**
     * Method 'getObligatorio'.
     *
     * @return String
     */
    public String getObligatorio() {
        return this.obligatorio;
    }

    /**
     * Method 'setObligatorio'.
     *
     * @param obligatorio String
     * @return
     */
    public void setObligatorio(String obligatorio) {
        this.obligatorio = obligatorio;
    }

    /**
     * @return the idBloque
     */
    public Long getIdBloque() {
        return idBloque;
    }

    /**
     * @param idBloque the idBloque to set
     */
    public void setIdBloque(Long idBloque) {
        this.idBloque = idBloque;
    }

    /**
     * @return the selectedAll
     */
    public Boolean getSelectedAll() {
        return selectedAll;
    }

    /**
     * @param selectedAll the selectedAll to set
     */
    public void setSelectedAll(Boolean selectedAll) {
        this.selectedAll = selectedAll;
    }

    /**
     * @return the selectedIds
     */
    public List<String> getSelectedIds() {
        return selectedIds;
    }

    /**
     * @param selectedIds the selectedIds to set
     */
    public void setSelectedIds(List<String> selectedIds) {
        this.selectedIds = selectedIds;
    }

    /**
     * @return the aviso
     */
    public String getAviso() {
        return aviso;
    }

    /**
     * @param aviso the aviso to set
     */
    public void setAviso(String aviso) {
        this.aviso = aviso;
    }

    /**
     * @return the respuestasAviso
     */
    public String getRespuestasAviso() {
        return respuestasAviso;
    }

    /**
     * @param respuestasAviso the respuestasAviso to set
     */
    public void setRespuestasAviso(String respuestasAviso) {
        this.respuestasAviso = respuestasAviso;
    }

    /**
     * @return the listRespuestas
     */
    public List<Y41eTipoRespuesta> getListRespuestas() {
        return listRespuestas;
    }

    /**
     * @param listRespuestas the listRespuestas to set
     */
    public void setListRespuestas(List<Y41eTipoRespuesta> listRespuestas) {
        this.listRespuestas = listRespuestas;
    }

    /**
     * @return the resultado
     */
    public Y41eResultados getResultado() {
        if(this.resultado==null){
            this.resultado = new Y41eResultados();
        }
        return resultado;
    }

    /**
     * @param resultado the resultado to set
     */
    public void setResultado(Y41eResultados resultado) {
        this.resultado = resultado;
    }

    /**
     * @return the isEnlazada
     */
    public String getIsEnlazada() {
        return isEnlazada;
    }

    /**
     * @param isEnlazada the isEnlazada to set
     */
    public void setIsEnlazada(String isEnlazada) {
        this.isEnlazada = isEnlazada;
    }

    /**
     * @return the hasEnlazada
     */
    public String getHasEnlazada() {
        return hasEnlazada;
    }

    /**
     * @param hasEnlazada the hasEnlazada to set
     */
    public void setHasEnlazada(String hasEnlazada) {
        this.hasEnlazada = hasEnlazada;
    }

    /**
     * @return the listaEnlazadas
     */
    public List<Y41ePreguntaEnlazada> getListaEnlazadas() {
        return listaEnlazadas;
    }

    /**
     * @param listaEnlazadas the listaEnlazadas to set
     */
    public void setListaEnlazadas(List<Y41ePreguntaEnlazada> listaEnlazadas) {
        this.listaEnlazadas = listaEnlazadas;
    }

    /**
     * @return the isBloqueEnlazada
     */
    public String getIsBloqueEnlazada() {
        return isBloqueEnlazada;
    }

    /**
     * @param isBloqueEnlazada the isBloqueEnlazada to set
     */
    public void setIsBloqueEnlazada(String isBloqueEnlazada) {
        this.isBloqueEnlazada = isBloqueEnlazada;
    }

    /**
     * @return the idPreguntaPadre
     */
    public Long getIdPreguntaPadre() {
        return idPreguntaPadre;
    }

    /**
     * @param idPreguntaPadre the idPreguntaPadre to set
     */
    public void setIdPreguntaPadre(Long idPreguntaPadre) {
        this.idPreguntaPadre = idPreguntaPadre;
    }

    /**
     * @return the respuestas
     */
    public String getRespuestas() {
        return respuestas;
    }

    /**
     * @param respuestas the respuestas to set
     */
    public void setRespuestas(String respuestas) {
        this.respuestas = respuestas;
    }

}
