package com.ejie.y41e.model;


import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.ejie.x38.serialization.JsonDateDeserializer;
import com.ejie.x38.serialization.JsonDateSerializer;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

/**
 * Y41eEnvio
 *  
 */

public class Y41eEnvio  implements java.io.Serializable {

    private static final long serialVersionUID = 1L;
    private Long idEnvio;
    private Y41eEncuesta encuesta;
    private String idUsuario;
    private String dataUsuario;
    private String email;
    private Date fecRespuesta;
    private Date fecRespuestaInicio;
    private Date fecRespuestaFin;
    private String param;
    private String error;
    private List<Y41eResultados> resultados = new ArrayList<Y41eResultados>();

    /** 
     * Method 'Y41eEnvio'.
     */
    public Y41eEnvio() {
        //constructor
    }

    /** 
     * Method 'Y41eEnvio'.
     * @param idEnvio Long
     */    
    public Y41eEnvio(Long idEnvio) {
        this.idEnvio = idEnvio;
    }

    /** 
     * Method 'Y41eEnvio'.
     * @param idEnvio Long
     * @param idUsuario String
     * @param email String
     * @param fecRespuesta Date
     * @param respondida String
     * @param encuesta Y41eEncuesta
     */
    public Y41eEnvio(Long idEnvio, String idUsuario, String email, Date fecRespuesta, String respondida, Y41eEncuesta encuesta) {
        this.idEnvio = idEnvio;
        this.encuesta = encuesta;
        this.idUsuario = idUsuario;
        this.email = email;
        this.fecRespuesta = fecRespuesta;
    }

    /**
     * Method 'getIdEnvio'.
     *
     * @return Long
     */
    public Long getIdEnvio() {
        return this.idEnvio;
    }

    /**
     * Method 'setIdEnvio'.
     *
     * @param idEnvio Long
     * @return
     */
    public void setIdEnvio(Long idEnvio) {
        this.idEnvio = idEnvio;
    }
    /**
     * Method 'getEncuesta'.
     *
     * @return Y41eEncuesta
     */
    public Y41eEncuesta getEncuesta() {
        if(this.encuesta==null){
            this.encuesta = new Y41eEncuesta();
        }
        return this.encuesta;
    }

    /**
     * Method 'setEncuesta'.
     *
     * @param encuesta Y41eEncuesta
     * @return
     */
    public void setEncuesta(Y41eEncuesta encuesta) {
        this.encuesta = encuesta;
    }
    /**
     * Method 'getIdUsuario'.
     *
     * @return String
     */


    public String getIdUsuario() {
        return this.idUsuario;
    }

    /**
     * Method 'setIdUsuario'.
     *
     * @param idUsuario String
     * @return
     */

    public void setIdUsuario(String idUsuario) {
        this.idUsuario = idUsuario;
    }
    /**
     * Method 'getEmail'.
     *
     * @return String
     */


    public String getEmail() {
        return this.email;
    }

    /**
     * Method 'setEmail'.
     *
     * @param email String
     * @return
     */

    public void setEmail(String email) {
        this.email = email;
    }
    /**
     * Method 'getFecRespuesta'.
     *
     * @return java.util.Date
     */

    @JsonSerialize(using = JsonDateSerializer.class)
    public Date getFecRespuesta() {
        return this.fecRespuesta;
    }

    /**
     * Method 'setFecRespuesta'.
     *
     * @param fecRespuesta java.util.Date
     * @return
     */
    @JsonDeserialize(using = JsonDateDeserializer.class)
    public void setFecRespuesta(Date fecRespuesta) {
        this.fecRespuesta = fecRespuesta;
    }

    /**
     * @return the resultados
     */
    @JsonIgnore
    public List<Y41eResultados> getResultados() {
        return resultados;
    }

    /**
     * @param resultados the resultados to set
     */
    public void setResultados(List<Y41eResultados> resultados) {
        this.resultados = resultados;
    }

    /**
     * @return the param
     */
    public String getParam() {
        return param;
    }

    /**
     * @param param the param to set
     */
    public void setParam(String param) {
        this.param = param;
    }

    /**
     * @return the fecRespuestaInicio
     */
    @JsonSerialize(using = JsonDateSerializer.class)
    public Date getFecRespuestaInicio() {
        return fecRespuestaInicio;
    }

    /**
     * @param fecRespuestaInicio the fecRespuestaInicio to set
     */
    @JsonDeserialize(using = JsonDateDeserializer.class)
    public void setFecRespuestaInicio(Date fecRespuestaInicio) {
        this.fecRespuestaInicio = fecRespuestaInicio;
    }

    /**
     * @return the fecRespuestaFin
     */
    @JsonSerialize(using = JsonDateSerializer.class)
    public Date getFecRespuestaFin() {
        return fecRespuestaFin;
    }

    /**
     * @param fecRespuestaFin the fecRespuestaFin to set
     */
    @JsonDeserialize(using = JsonDateDeserializer.class)
    public void setFecRespuestaFin(Date fecRespuestaFin) {
        this.fecRespuestaFin = fecRespuestaFin;
    }

    /**
     * @return the error
     */
    public String getError() {
        return error;
    }

    /**
     * @param error the error to set
     */
    public void setError(String error) {
        this.error = error;
    }

    /**
     * @return the dataUsuario
     */
    public String getDataUsuario() {
        return dataUsuario;
    }

    /**
     * @param dataUsuario the dataUsuario to set
     */
    public void setDataUsuario(String dataUsuario) {
        this.dataUsuario = dataUsuario;
    }

}

