package com.ejie.y41e.model; 

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.ejie.x38.serialization.JsonDateDeserializer;
import com.ejie.x38.serialization.JsonDateSerializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

/**
 * Y41eEncuesta
 *  
 */

public class Y41eEncuesta extends Y41eDetalle implements java.io.Serializable {

    private static final long serialVersionUID = 1L;
    private Long idEncuesta;
    private Y41eOrigen origen;
    private Y41eArea area;
    private String enviada;
    private Date fecEnvio;
    private Date fecEnvioInicio;
    private Date fecEnvioFin;
    private Date fecVigInicio;
    private Date fecVigFin;
    private Long periodoResp;
    private String periodoRespuesta;
    private String respondida;
    private Long numEnvios;
    private Long numRespuestas;
    private Long numSinRespuestas;
    private Long idEnvio;
    private List<Y41eBloque> listaBloques = new ArrayList<Y41eBloque>();
    private String url;
    /** 
     * Method 'Y41eEncuesta'.
     */
    public Y41eEncuesta() {
        //constructor
    }

    /** 
     * Method 'Y41eEncuesta'.
     * @param idEncuesta Long
     */    
    public Y41eEncuesta(Long idEncuesta) {
        this.idEncuesta = idEncuesta;
    }



    /**
     * @param idEncuesta
     * @param descPublEs String
     * @param descPublEu String
     * @param descIntEs String
     * @param descIntEu String
     */
    public Y41eEncuesta(Long idEncuesta, String descPublEs, String descPublEu, String descIntEs, String descIntEu) {
        super(descPublEs, descPublEu, descIntEs, descIntEu);
        this.idEncuesta = idEncuesta;
    }

    /**
     * Method 'getIdEncuesta'.
     *
     * @return Long
     */


    public Long getIdEncuesta() {
        return this.idEncuesta;
    }

    /**
     * Method 'setIdEncuesta'.
     *
     * @param idEncuesta Long
     * @return
     */

    public void setIdEncuesta(Long idEncuesta) {
        this.idEncuesta = idEncuesta;
    }
    /**
     * Method 'getY41eOrigen'.
     *
     * @return Y41eOrigen
     */
    public Y41eOrigen getOrigen() {
        if(this.origen==null){
            this.origen = new Y41eOrigen();
        }
        return this.origen;
    }

    /**
     * Method 'setY41eOrigen'.
     *
     * @param origen Y41eOrigen
     * @return
     */

    public void setOrigen(Y41eOrigen origen) {
        this.origen = origen;
    }

    /**
     * @return the area
     */
    public Y41eArea getArea() {
        if(area==null){
            area = new Y41eArea();
        }
        return area;
    }

    /**
     * @param area the area to set
     */
    public void setArea(Y41eArea area) {
        this.area = area;
    }

    /**
     * Method 'getEnviada'.
     *
     * @return String
     */


    public String getEnviada() {
        return this.enviada;
    }

    /**
     * Method 'setEnviada'.
     *
     * @param enviada String
     * @return
     */

    public void setEnviada(String enviada) {
        this.enviada = enviada;
    }
    /**
     * Method 'getFecEnvio'.
     *
     * @return java.util.Date
     */

    @JsonSerialize(using = JsonDateSerializer.class)
    public Date getFecEnvio() {
        return this.fecEnvio;
    }

    /**
     * Method 'setFecEnvio'.
     *
     * @param fecEnvio java.util.Date
     * @return
     */
    @JsonDeserialize(using = JsonDateDeserializer.class)
    public void setFecEnvio(Date fecEnvio) {
        this.fecEnvio = fecEnvio;
    }
    /**
     * Method 'getFecVigInicio'.
     *
     * @return java.util.Date
     */

    @JsonSerialize(using = JsonDateSerializer.class)
    public Date getFecVigInicio() {
        return this.fecVigInicio;
    }

    /**
     * Method 'setFecVigInicio'.
     *
     * @param fecVigInicio java.util.Date
     * @return
     */
    @JsonDeserialize(using = JsonDateDeserializer.class)
    public void setFecVigInicio(Date fecVigInicio) {
        this.fecVigInicio = fecVigInicio;
    }
    /**
     * Method 'getFecVigFin'.
     *
     * @return java.util.Date
     */

    @JsonSerialize(using = JsonDateSerializer.class)
    public Date getFecVigFin() {
        return this.fecVigFin;
    }

    /**
     * Method 'setFecVigFin'.
     *
     * @param fecVigFin java.util.Date
     * @return
     */
    @JsonDeserialize(using = JsonDateDeserializer.class)
    public void setFecVigFin(Date fecVigFin) {
        this.fecVigFin = fecVigFin;
    }

    /**
     * Method 'getPeriodoResp'.
     *
     * @return Long
     */
    public Long getPeriodoResp() {
        return this.periodoResp;
    }

    /**
     * Method 'setPeriodoResp'.
     *
     * @param periodoResp Long
     * @return
     */
    public void setPeriodoResp(Long periodoResp) {
        this.periodoResp = periodoResp;
    }

    /**
     * @return the respondida
     */
    public String getRespondida() {
        return respondida;
    }

    /**
     * @param respondida the respondida to set
     */
    public void setRespondida(String respondida) {
        this.respondida = respondida;
    }

    /**
     * @return the fecEnvioInicio
     */
    @JsonSerialize(using = JsonDateSerializer.class)
    public Date getFecEnvioInicio() {
        return fecEnvioInicio;
    }

    /**
     * @param fecEnvioInicio the fecEnvioInicio to set
     */
    @JsonDeserialize(using = JsonDateDeserializer.class)
    public void setFecEnvioInicio(Date fecEnvioInicio) {
        this.fecEnvioInicio = fecEnvioInicio;
    }

    /**
     * @return the fecEnvioFin
     */
    @JsonSerialize(using = JsonDateSerializer.class)
    public Date getFecEnvioFin() {
        return fecEnvioFin;
    }

    /**
     * @param fecEnvioFin the fecEnvioFin to set
     */
    @JsonDeserialize(using = JsonDateDeserializer.class)
    public void setFecEnvioFin(Date fecEnvioFin) {
        this.fecEnvioFin = fecEnvioFin;
    }

    /**
     * @return the periodoRespuesta
     */
    public String getPeriodoRespuesta() {
        return periodoRespuesta;
    }

    /**
     * @param periodoRespuesta the periodoRespuesta to set
     */
    public void setPeriodoRespuesta(String periodoRespuesta) {
        this.periodoRespuesta = periodoRespuesta;
    }

    /**
     * @return the numEnvios
     */
    public Long getNumEnvios() {
        return numEnvios;
    }

    /**
     * @param numEnvios the numEnvios to set
     */
    public void setNumEnvios(Long numEnvios) {
        this.numEnvios = numEnvios;
    }

    /**
     * @return the numRespuestas
     */
    public Long getNumRespuestas() {
        return numRespuestas;
    }

    /**
     * @param numRespuestas the numRespuestas to set
     */
    public void setNumRespuestas(Long numRespuestas) {
        this.numRespuestas = numRespuestas;
    }

    /**
     * @return the numSinRespuestas
     */
    public Long getNumSinRespuestas() {
        return numSinRespuestas;
    }

    /**
     * @param numSinRespuestas the numSinRespuestas to set
     */
    public void setNumSinRespuestas(Long numSinRespuestas) {
        this.numSinRespuestas = numSinRespuestas;
    }

    /**
     * @return the listaBloques
     */
    public List<Y41eBloque> getListaBloques() {
        return listaBloques;
    }

    /**
     * @param listaBloques the listaBloques to set
     */
    public void setListaBloques(List<Y41eBloque> listaBloques) {
        this.listaBloques = listaBloques;
    }

    /**
     * @return the idEnvio
     */
    public Long getIdEnvio() {
        return idEnvio;
    }

    /**
     * @param idEnvio the idEnvio to set
     */
    public void setIdEnvio(Long idEnvio) {
        this.idEnvio = idEnvio;
    }

    /**
     * @return the url
     */
    public String getUrl() {
        return url;
    }

    /**
     * @param url the url to set
     */
    public void setUrl(String url) {
        this.url = url;
    }
}