package com.ejie.y41e.model;

import java.util.Date;
import java.util.Locale;

import org.springframework.context.i18n.LocaleContextHolder;

import com.ejie.x38.serialization.JsonDateDeserializer;
import com.ejie.x38.serialization.JsonDateSerializer;
import com.ejie.y41e.common.Y41eConstants;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

/**
 * Y41eDetalle
 *  
 */

public class Y41eDetalle  implements java.io.Serializable {

    private static final long serialVersionUID = 1L;
    private String descPublEs;
    private String descPublEu;
    private String descIntEs;
    private String descIntEu;
    private Date fecUltModif;
    private Date fecAlta;
    private String usuAlta;
    private String usuModif;
    private String descPubl;
    private String descInt;
    private String activa;

    /** 
     * Method 'Y41eDetalle'.
     */
    public Y41eDetalle() {
        //constructor
    }

    /**
     * @param descPublEs String
     * @param descPublEu String
     * @param descIntEs String
     * @param descIntEu String
     */
    public Y41eDetalle(String descPublEs, String descPublEu, String descIntEs, String descIntEu) {
        this.descPublEs = descPublEs;
        this.descPublEu = descPublEu;
        this.descIntEs = descIntEs;
        this.descIntEu = descIntEu;
    }



    /**
     * @return the descPublEs
     */
    public String getDescPublEs() {
        return descPublEs;
    }

    /**
     * @param descPublEs the descPublEs to set
     */
    public void setDescPublEs(String descPublEs) {
        this.descPublEs = descPublEs;
    }

    /**
     * @return the descPublEu
     */
    public String getDescPublEu() {
        return descPublEu;
    }

    /**
     * @param descPublEu the descPublEu to set
     */
    public void setDescPublEu(String descPublEu) {
        this.descPublEu = descPublEu;
    }

    /**
     * @return the descIntEs
     */
    public String getDescIntEs() {
        return descIntEs;
    }

    /**
     * @param descIntEs the descIntEs to set
     */
    public void setDescIntEs(String descIntEs) {
        this.descIntEs = descIntEs;
    }

    /**
     * @return the descIntEu
     */
    public String getDescIntEu() {
        return descIntEu;
    }

    /**
     * @param descIntEu the descIntEu to set
     */
    public void setDescIntEu(String descIntEu) {
        this.descIntEu = descIntEu;
    }

    /**
     * @return the fecUltModif
     */
    @JsonSerialize(using = JsonDateSerializer.class)
    public Date getFecUltModif() {
        return this.fecUltModif;
    }

    /**
     * @param fecUltModif the fecUltModif to set
     */
    @JsonDeserialize(using = JsonDateDeserializer.class)
    public void setFecUltModif(Date fecUltmodif) {
        this.fecUltModif = fecUltmodif;
    }

    /**
     * @return the fecAlta
     */
    @JsonSerialize(using = JsonDateSerializer.class)
    public Date getFecAlta() {
        return this.fecAlta;
    }

    /**
     * @param fecAlta the fecAlta to set
     */
    @JsonDeserialize(using = JsonDateDeserializer.class)
    public void setFecAlta(Date fecAlta) {
        this.fecAlta = fecAlta;
    }

    /**
     * @return the usuAlta
     */
    public String getUsuAlta() {
        return usuAlta;
    }

    /**
     * @param usuAlta the usuAlta to set
     */
    public void setUsuAlta(String usuAlta) {
        this.usuAlta = usuAlta;
    }

    /**
     * @return the usuModif
     */
    public String getUsuModif() {
        return usuModif;
    }

    /**
     * @param usuModif the usuModif to set
     */
    public void setUsuModif(String usuModif) {
        this.usuModif = usuModif;
    }

    /**
     * @return the descPubl
     */
    public String getDescPubl() {
        return descPubl;
    }

    /**
     * @param descPubl the descPubl to set
     */
    public void setDescPubl(String descPubl) {
        this.descPubl = descPubl;
    }

    /**
     * @return the descInt
     */
    public String getDescInt() {
        return descInt;
    }

    /**
     * @param descInt the descInt to set
     */
    public void setDescInt(String descInt) {
        this.descInt = descInt;
    }

    /**
     * @return String
     */
    public String getDescPublLocale() {
        Locale locale = LocaleContextHolder.getLocale();
        if(Y41eConstants.LANG_CASTELLANO.equals(locale.getLanguage())){
            return descPublEs;
        }else{
            return descPublEu;
        }
    }


    /**
     * @return String
     */
    public String getDescIntLocale() {
        Locale locale = LocaleContextHolder.getLocale();
        if(Y41eConstants.LANG_CASTELLANO.equals(locale.getLanguage())){
            return descIntEs;
        }else{
            return descIntEu;
        }
    }

    /**
     * @return String
     */
    public String getDescPublCompleta(){
        StringBuilder desc = new StringBuilder();
        desc.append(this.descPublEu).append(" / ").append(this.descPublEs);
        return desc.toString();
    }

    /**
     * Method 'getActiva'.
     *
     * @return String
     */


    public String getActiva() {
        return this.activa;
    }

    /**
     * Method 'setActiva'.
     *
     * @param activa String
     * @return
     */

    public void setActiva(String activa) {
        this.activa = activa;
    }

}
