package com.ejie.y41e.model;

import java.util.Locale;

import org.apache.commons.lang.StringUtils;
import org.springframework.context.i18n.LocaleContextHolder;

import com.ejie.y41e.common.Y41eConstants;

/**
 * Y41eDescripcion
 *  
 */

public class Y41eDescripcion implements java.io.Serializable {

    private static final long serialVersionUID = 1L;
    private String descEs;
    private String descEu;
    private String activa;
    private String desc;

    /** 
     * Method 'Area'.
     */
    public Y41eDescripcion() {
        //constructor
    }



    /**
     * @param descEs String
     * @param descEu String
     * @param activa String
     */
    public Y41eDescripcion(String descEs, String descEu, String activa) {
        this.descEs = descEs;
        this.descEu = descEu;
        this.activa = activa;
    }

    /**
     * @return the descEs
     */
    public String getDescEs() {
        return descEs;
    }

    /**
     * @param descEs the descEs to set
     */
    public void setDescEs(String descEs) {
        this.descEs = descEs;
    }

    /**
     * @return the descEu
     */
    public String getDescEu() {
        return descEu;
    }

    /**
     * @param descEu the descEu to set
     */
    public void setDescEu(String descEu) {
        this.descEu = descEu;
    }

    /**
     * @return the activa
     */
    public String getActiva() {
        return activa;
    }

    /**
     * @param activa the activa to set
     */
    public void setActiva(String activa) {
        this.activa = activa;
    }

    /**
     * @return the desc
     */
    public String getDesc() {
        return desc;
    }

    /**
     * @param desc the desc to set
     */
    public void setDesc(String desc) {
        this.desc = desc;
    }

    /**
     * @return String
     */
    public String getDescLocale() {
        Locale locale = LocaleContextHolder.getLocale();
        if(Y41eConstants.LANG_CASTELLANO.equals(locale.getLanguage())){
            return descEs;
        }else{
            return descEu;
        }
    }

    public String getDescCompleta(){
        StringBuilder descCompleta = new StringBuilder();
        descCompleta.append(this.descEu).append(" / ").append(this.descEs);
        return descCompleta.toString();
    }

    public String getDescWeb(){
        StringBuilder descWeb = new StringBuilder();
        if(!StringUtils.equals(this.descEs, this.descEu)){
            descWeb.append(this.descEu).append("/").append(this.descEs);
        }else{
            descWeb.append(this.descEu);
        }
        return descWeb.toString();
    }

}

