package com.ejie.y41e.model;

import java.util.ArrayList;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnore;

/**
 * Y41eArea
 *  
 */

public class Y41eArea extends Y41eDescripcion implements java.io.Serializable {

    private static final long serialVersionUID = 1L;
    private Integer idArea;
    private List<Y41eEncuesta> encuestas = new ArrayList<Y41eEncuesta>();

    /** 
     * Method 'Area'.
     */
    public Y41eArea() {
        //constructor
    }

    /** 
     * Method 'Area'.
     * @param id Integer
     */    
    public Y41eArea(Integer id) {
        this.idArea = id;
    }



    /** 
     * Method 'Area'.
     * @param id Integer
     * @param descEs String
     * @param descEu String
     * @param activa String
     */
    public Y41eArea(Integer id, String descEs, String descEu, String activa) {
        super(descEs, descEu, activa);
        this.idArea = id;
    }

    /**
     * Method 'getIdArea'.
     *
     * @return Integer
     */


    public Integer getIdArea() {
        return this.idArea;
    }

    /**
     * Method 'setIdArea'.
     *
     * @param id Integer
     * @return
     */

    public void setIdArea(Integer id) {
        this.idArea = id;
    }

    /**
     * Method 'getEncuestas'.
     *
     * @return List
     */
    @JsonIgnore
    public List<Y41eEncuesta> getEncuestas() {
        return this.encuestas;
    }

    /**
     * Method 'setEncuestas'.
     *
     * @param y41eEncuestas List
     * @return
     */
    public void setEncuestas(List<Y41eEncuesta> y41eEncuestas) {
        this.encuestas = y41eEncuestas;
    }


}

