/**
 * Y41eResultadosDestinatarioRowMapper
 */
package com.ejie.y41e.dao.rwmap;

import java.sql.ResultSet;
import java.sql.SQLException;

import org.springframework.jdbc.core.RowMapper;

import com.ejie.y41e.model.Y41eResultados;

/**
 *  
 *
 */
public class Y41eResultadosDestinatarioRowMapper implements RowMapper<Y41eResultados>{

    /* (non-Javadoc)
     * @see org.springframework.jdbc.core.RowMapper#mapRow(java.sql.ResultSet, int)
     */
    @Override
    public Y41eResultados mapRow(ResultSet resultSet, int rowNum) throws SQLException {
        Y41eResultados resultados = new Y41eResultados();
        resultados.getEnvio().setIdUsuario(resultSet.getString("ID_USUARIO_010"));
        resultados.getEnvio().setFecRespuesta(resultSet.getDate("FEC_RESPUESTA_010"));
        resultados.getEnvio().getEncuesta().setIdEncuesta(resultSet.getLong("ID_ENCUESTA_001"));
        resultados.getEnvio().getEncuesta().setDescPublEs(resultSet.getString("DESC_PUBL_ES_001"));
        resultados.getEnvio().getEncuesta().setDescPublEu(resultSet.getString("DESC_PUBL_EU_001"));
        resultados.getBloque().setIdBloque(resultSet.getLong("ID_BLOQUE_002"));
        resultados.getBloque().setDescPublEs(resultSet.getString("DESC_PUBL_ES_002"));
        resultados.getBloque().setDescPublEu(resultSet.getString("DESC_PUBL_EU_002"));
        resultados.getPregunta().setIdPregunta(resultSet.getLong("ID_PREGUNTA_004"));
        resultados.getPregunta().setDescPublEs(resultSet.getString("DESC_PUBL_ES_004"));
        resultados.getPregunta().setDescPublEu(resultSet.getString("DESC_PUBL_EU_004"));
        resultados.getRespuesta().setIdTipoRespuesta(resultSet.getLong("ID_TIPO_RESPUESTA_009"));
        resultados.getRespuesta().setDescEs(resultSet.getString("DESC_ES_009"));
        resultados.getRespuesta().setDescEu(resultSet.getString("DESC_EU_009"));
        resultados.setTexto(resultSet.getString("TEXTO_011"));
        return resultados;
    }

}
