/**
 * Y41eRelBloquePreguntaRowMapper
 */
package com.ejie.y41e.dao.rwmap;

import java.sql.ResultSet;
import java.sql.SQLException;

import org.springframework.jdbc.core.RowMapper;

import com.ejie.y41e.model.Y41eRelBloquePregunta;

/**
 *  
 *
 */
public class Y41eRelBloquePreguntaRowMapper implements RowMapper<Y41eRelBloquePregunta>{

    /* (non-Javadoc)
     * @see org.springframework.jdbc.core.RowMapper#mapRow(java.sql.ResultSet, int)
     */
    @Override
    public Y41eRelBloquePregunta mapRow(ResultSet resultSet, int rowNum) throws SQLException {
        Y41eRelBloquePregunta relBloquePregunta = new Y41eRelBloquePregunta();
        relBloquePregunta.getBloque().setIdBloque(resultSet.getLong("ID_BLOQUE_005"));
        relBloquePregunta.getPregunta().setIdPregunta(resultSet.getLong("ID_PREGUNTA_005"));
        relBloquePregunta.getPregunta().setDescPublEs(resultSet.getString("DESC_PUBL_ES_004"));
        relBloquePregunta.getPregunta().setDescPublEu(resultSet.getString("DESC_PUBL_EU_004"));
        relBloquePregunta.getPregunta().setDescIntEs(resultSet.getString("DESC_INT_ES_004"));
        relBloquePregunta.getPregunta().setDescIntEu(resultSet.getString("DESC_INT_EU_004"));
        relBloquePregunta.getPregunta().setObligatorio(resultSet.getString("OBLIGATORIO_004"));
        relBloquePregunta.getPregunta().setAviso(resultSet.getString("AVISO_004"));
        relBloquePregunta.getPregunta().getTipoPregunta().setIdTipoPregunta(resultSet.getLong("ID_TIPO_PREGUNTA_004"));
        relBloquePregunta.getPregunta().getTipoPregunta().setDescEs(resultSet.getString("DESC_ES_008"));
        relBloquePregunta.getPregunta().getTipoPregunta().setDescEu(resultSet.getString("DESC_EU_008"));
        relBloquePregunta.getPregunta().setIsEnlazada(resultSet.getString("IS_ENLAZADA"));
        relBloquePregunta.getPregunta().setIsBloqueEnlazada(resultSet.getString("IS_BLOQUE_ENLAZADA"));
        relBloquePregunta.getPregunta().setHasEnlazada(resultSet.getString("HAS_ENLAZADA"));
        relBloquePregunta.setOrdenPreg(resultSet.getLong("ORDEN_PREG_005"));
        return relBloquePregunta; 
    }

}
