/**
 * Y41ePreguntaRowMapper
 */
package com.ejie.y41e.dao.rwmap;

import java.sql.ResultSet;
import java.sql.SQLException;

import org.springframework.jdbc.core.RowMapper;

import com.ejie.y41e.model.Y41ePregunta;

/**
 *  
 *
 */
public class Y41ePreguntaRowMapper implements RowMapper<Y41ePregunta>{

    /* (non-Javadoc)
     * @see org.springframework.jdbc.core.RowMapper#mapRow(java.sql.ResultSet, int)
     */
    @Override
    public Y41ePregunta mapRow(ResultSet resultSet, int rowNum) throws SQLException {
        Y41ePregunta pregunta = new Y41ePregunta();
        pregunta.setIdPregunta(resultSet.getLong("ID_PREGUNTA_004"));
        pregunta.setDescPublEs(resultSet.getString("DESC_PUBL_ES_004"));
        pregunta.setDescPublEu(resultSet.getString("DESC_PUBL_EU_004"));
        pregunta.setDescIntEs(resultSet.getString("DESC_INT_ES_004"));
        pregunta.setDescIntEu(resultSet.getString("DESC_INT_EU_004"));
        pregunta.setActiva(resultSet.getString("ACTIVA_004"));
        pregunta.setObligatorio(resultSet.getString("OBLIGATORIO_004"));
        pregunta.getTipoPregunta().setIdTipoPregunta(resultSet.getLong("ID_TIPO_PREGUNTA_004"));
        pregunta.getTipoPregunta().setDescEs(resultSet.getString("DESC_ES_008"));
        pregunta.getTipoPregunta().setDescEu(resultSet.getString("DESC_EU_008"));
        pregunta.setFecAlta(resultSet.getDate("FEC_ALTA_004"));
        pregunta.setFecUltModif(resultSet.getDate("FEC_ULTMODIF_004"));
        pregunta.setUsuAlta(resultSet.getString("USU_ALTA_004"));
        pregunta.setUsuModif(resultSet.getString("USU_MODIF_004"));
        pregunta.setAviso(resultSet.getString("AVISO_004"));
        return pregunta;
    }

}
