/**
 * Y41eGraficoRowMapper
 */
package com.ejie.y41e.dao.rwmap;

import java.sql.ResultSet;
import java.sql.SQLException;

import org.springframework.jdbc.core.RowMapper;

import com.ejie.y41e.model.Y41eBloque;
import com.ejie.y41e.model.Y41eGrafico;
import com.ejie.y41e.model.Y41ePregunta;

/**
 *  
 *
 */
public class Y41eGraficoRowMapper implements RowMapper<Y41eGrafico>{

    /* (non-Javadoc)
     * @see org.springframework.jdbc.core.RowMapper#mapRow(java.sql.ResultSet, int)
     */
    @Override
    public Y41eGrafico mapRow(ResultSet resultSet, int rowNum) throws SQLException {
        Y41eGrafico grafico = new Y41eGrafico();
        Y41eBloque bloque = new Y41eBloque();
        bloque.setIdBloque(resultSet.getLong("ID_BLOQUE_002"));
        bloque.setDescPublEs(resultSet.getString("DESC_PUBL_ES_002"));
        bloque.setDescPublEu(resultSet.getString("DESC_PUBL_EU_002"));
        bloque.setDescIntEs(resultSet.getString("DESC_INT_ES_002"));
        bloque.setDescIntEu(resultSet.getString("DESC_INT_EU_002"));
        grafico.setBloque(bloque);
        Y41ePregunta pregunta = new Y41ePregunta();
        pregunta.setIdPregunta(resultSet.getLong("ID_PREGUNTA_004"));
        pregunta.setDescPublEs(resultSet.getString("DESC_PUBL_ES_004"));
        pregunta.setDescPublEu(resultSet.getString("DESC_PUBL_EU_004"));
        pregunta.setDescIntEs(resultSet.getString("DESC_INT_ES_004"));
        pregunta.setDescIntEu(resultSet.getString("DESC_INT_EU_004"));
        pregunta.getTipoPregunta().setTipoGrafico(resultSet.getString("GRAFICO_008"));
        grafico.setPregunta(pregunta);
        return grafico;
    }

}
