/**
 * Y41eEnvioRowMapper
 */
package com.ejie.y41e.dao.rwmap;

import java.sql.ResultSet;
import java.sql.SQLException;

import org.springframework.jdbc.core.RowMapper;

import com.ejie.y41e.model.Y41eEnvio;

/**
 *  
 *
 */
public class Y41eEnvioRowMapper implements RowMapper<Y41eEnvio>{

    /* (non-Javadoc)
     * @see org.springframework.jdbc.core.RowMapper#mapRow(java.sql.ResultSet, int)
     */
    @Override
    public Y41eEnvio mapRow(ResultSet resultSet, int rowNum) throws SQLException {
        Y41eEnvio envio = new Y41eEnvio();
        envio.setIdEnvio(resultSet.getLong("ID_ENVIO_010"));
        envio.setIdUsuario(resultSet.getString("ID_USUARIO_010"));
        envio.getEncuesta().setIdEncuesta(resultSet.getLong("ID_ENCUESTA_010"));
        envio.getEncuesta().setFecEnvio(resultSet.getDate("FEC_ENVIO_001"));
        envio.getEncuesta().setDescPublEs(resultSet.getString("DESC_PUBL_ES_001"));
        envio.getEncuesta().setDescPublEu(resultSet.getString("DESC_PUBL_EU_001"));
        envio.getEncuesta().setDescIntEs(resultSet.getString("DESC_INT_ES_001"));
        envio.getEncuesta().setDescIntEu(resultSet.getString("DESC_INT_EU_001"));
        envio.getEncuesta().getArea().setIdArea(resultSet.getInt("ID_AREA_001"));
        envio.getEncuesta().getArea().setDescEs(resultSet.getString("DESC_ES_007"));
        envio.getEncuesta().getArea().setDescEu(resultSet.getString("DESC_EU_007"));
        envio.getEncuesta().getOrigen().setIdOrigen(resultSet.getLong("ID_ORIGEN_001"));
        envio.getEncuesta().getOrigen().setDescEs(resultSet.getString("DESC_ES_006"));
        envio.getEncuesta().getOrigen().setDescEu(resultSet.getString("DESC_EU_006"));
        envio.setEmail(resultSet.getString("EMAIL_010"));
        envio.setFecRespuesta(resultSet.getDate("FEC_RESPUESTA_010"));

        return envio; 
    } 

}
