/**
 * Y41eEncuestaRowMapper
 */
package com.ejie.y41e.dao.rwmap;

import java.sql.ResultSet;
import java.sql.SQLException;

import org.springframework.jdbc.core.RowMapper;

import com.ejie.y41e.model.Y41eEncuesta;

/**
 *  
 *
 */
public class Y41eEncuestaRowMapper implements RowMapper<Y41eEncuesta>{

    /* (non-Javadoc)
     * @see org.springframework.jdbc.core.RowMapper#mapRow(java.sql.ResultSet, int)
     */
    @Override
    public Y41eEncuesta mapRow(ResultSet resultSet, int rowNum) throws SQLException {
        Y41eEncuesta encuesta = new Y41eEncuesta();
        encuesta.setIdEncuesta(resultSet.getLong("ID_ENCUESTA_001"));
        encuesta.setDescPublEs(resultSet.getString("DESC_PUBL_ES_001"));
        encuesta.setDescPublEu(resultSet.getString("DESC_PUBL_EU_001"));
        encuesta.setDescIntEs(resultSet.getString("DESC_INT_ES_001"));
        encuesta.setDescIntEu(resultSet.getString("DESC_INT_EU_001"));
        encuesta.getArea().setIdArea(resultSet.getInt("ID_AREA_001"));
        encuesta.getArea().setDescEs(resultSet.getString("DESC_ES_007"));
        encuesta.getArea().setDescEu(resultSet.getString("DESC_EU_007"));
        encuesta.setActiva(resultSet.getString("ACTIVA_001"));
        encuesta.setEnviada(resultSet.getString("ENVIADA_001"));
        encuesta.setFecEnvio(resultSet.getDate("FEC_ENVIO_001"));
        encuesta.setFecVigInicio(resultSet.getDate("FEC_VIG_INICIO_001"));
        encuesta.setFecVigFin(resultSet.getDate("FEC_VIG_FIN_001"));
        encuesta.setPeriodoResp(resultSet.getLong("PERIODO_RESP_001"));
        if(encuesta.getPeriodoResp()==0){
            encuesta.setPeriodoResp(null);
        }
        encuesta.setFecAlta(resultSet.getDate("FEC_ALTA_001"));
        encuesta.setFecUltModif(resultSet.getDate("FEC_ULTMODIF_001"));
        encuesta.setUsuAlta(resultSet.getString("USU_ALTA_001"));
        encuesta.setUsuModif(resultSet.getString("USU_MODIF_001"));
        encuesta.getOrigen().setIdOrigen(resultSet.getLong("ID_ORIGEN_001"));
        encuesta.getOrigen().setDescEs(resultSet.getString("DESC_ES_006"));
        encuesta.getOrigen().setDescEu(resultSet.getString("DESC_EU_006"));
        encuesta.setRespondida(resultSet.getString("RESPONDIDA"));
        encuesta.setUrl(resultSet.getString("PARAM_001"));
        return encuesta;
    }

}
