/**
 * Y41eEncResultadoRowMapper
 */
package com.ejie.y41e.dao.rwmap;

import java.sql.ResultSet;
import java.sql.SQLException;

import org.springframework.jdbc.core.RowMapper;

import com.ejie.y41e.model.Y41eEncuesta;

/**
 *  
 *
 */
public class Y41eEncResultadoRowMapper implements RowMapper<Y41eEncuesta>{

    /* (non-Javadoc)
     * @see org.springframework.jdbc.core.RowMapper#mapRow(java.sql.ResultSet, int)
     */
    @Override
    public Y41eEncuesta mapRow(ResultSet resultSet, int rowNum) throws SQLException {
        Y41eEncuesta encuestaResult = new Y41eEncuesta();
        encuestaResult.setIdEncuesta(resultSet.getLong("ID_ENCUESTA_001"));
        encuestaResult.setDescPublEs(resultSet.getString("DESC_PUBL_ES_001"));
        encuestaResult.setDescPublEu(resultSet.getString("DESC_PUBL_EU_001"));
        encuestaResult.setDescIntEs(resultSet.getString("DESC_INT_ES_001"));
        encuestaResult.setDescIntEu(resultSet.getString("DESC_INT_EU_001"));
        encuestaResult.getArea().setIdArea(resultSet.getInt("ID_AREA_001"));
        encuestaResult.getArea().setDescEs(resultSet.getString("DESC_ES_007"));
        encuestaResult.getArea().setDescEu(resultSet.getString("DESC_EU_007"));
        encuestaResult.getOrigen().setIdOrigen(resultSet.getLong("ID_ORIGEN_001"));
        encuestaResult.getOrigen().setDescEs(resultSet.getString("DESC_ES_006"));
        encuestaResult.getOrigen().setDescEu(resultSet.getString("DESC_EU_006"));
        encuestaResult.setActiva(resultSet.getString("ACTIVA_001"));
        encuestaResult.setNumEnvios(resultSet.getLong("NUM_ENVIOS"));
        encuestaResult.setNumRespuestas(resultSet.getLong("NUM_RESPUESTAS"));
        encuestaResult.setNumSinRespuestas(resultSet.getLong("NUM_SIN_RESPUESTAS"));
        return encuestaResult; 
    }

}
