/**
 * Y41eEncResultadoRowMapper
 */
package com.ejie.y41e.dao.rwmap;

import java.sql.ResultSet;
import java.sql.SQLException;

import org.springframework.jdbc.core.RowMapper;

import com.ejie.y41e.model.Y41eEnvio;

/**
 *  
 *
 */
public class Y41eDestResultadoRowMapper implements RowMapper<Y41eEnvio>{

    /* (non-Javadoc)
     * @see org.springframework.jdbc.core.RowMapper#mapRow(java.sql.ResultSet, int)
     */
    @Override
    public Y41eEnvio mapRow(ResultSet resultSet, int rowNum) throws SQLException {
        Y41eEnvio destinatario = new Y41eEnvio();
        destinatario.setIdEnvio(resultSet.getLong("ID_ENVIO_010"));
        destinatario.setIdUsuario(resultSet.getString("ID_USUARIO_010"));
        destinatario.getEncuesta().setIdEncuesta(resultSet.getLong("ID_ENCUESTA_010"));
        destinatario.getEncuesta().setDescPublEs(resultSet.getString("DESC_PUBL_ES_001"));
        destinatario.getEncuesta().setDescPublEu(resultSet.getString("DESC_PUBL_EU_001"));
        destinatario.getEncuesta().setDescIntEs(resultSet.getString("DESC_INT_ES_001"));
        destinatario.getEncuesta().setDescIntEu(resultSet.getString("DESC_INT_EU_001"));
        destinatario.getEncuesta().getArea().setIdArea(resultSet.getInt("ID_AREA_001"));
        destinatario.getEncuesta().getArea().setDescEs(resultSet.getString("DESC_ES_007"));
        destinatario.getEncuesta().getArea().setDescEu(resultSet.getString("DESC_EU_007"));
        destinatario.getEncuesta().getOrigen().setIdOrigen(resultSet.getLong("ID_ORIGEN_001"));
        destinatario.getEncuesta().getOrigen().setDescEs(resultSet.getString("DESC_ES_006"));
        destinatario.getEncuesta().getOrigen().setDescEu(resultSet.getString("DESC_EU_006"));
        destinatario.getEncuesta().setFecEnvio(resultSet.getDate("FEC_ENVIO_001"));
        destinatario.setFecRespuesta(resultSet.getDate("FEC_RESPUESTA_010"));
        return destinatario; 
    }

}
