/**
 * Y41eEncResultadoRowMapper
 */
package com.ejie.y41e.dao.rwmap;

import java.io.InputStream;
import java.io.StringWriter;
import java.sql.ResultSet;
import java.sql.SQLException;

import org.apache.commons.io.IOUtils;
import org.springframework.jdbc.core.RowMapper;

import com.ejie.y41e.common.exceptions.Y41eRuntimeException;
import com.ejie.y41e.model.Y41eConfiguracion;

/**
 *  
 *
 */
public class Y41eConfiguracionRowMapper implements RowMapper<Y41eConfiguracion>{

    /* (non-Javadoc)
     * @see org.springframework.jdbc.core.RowMapper#mapRow(java.sql.ResultSet, int)
     */
    @Override
    public Y41eConfiguracion mapRow(ResultSet resultSet, int rowNum) throws SQLException {
        Y41eConfiguracion configuracion = new Y41eConfiguracion();
        configuracion.setIdConfig(resultSet.getInt("ID_CONFIG_012"));
        configuracion.setAsuntoEs(resultSet.getString("ASUNTO_ES_012"));
        configuracion.setAsuntoEu(resultSet.getString("ASUNTO_EU_012"));
        configuracion.setEmail(resultSet.getString("EMAIL_012"));

        if (resultSet.getClob("MENSAJE_ES_012") != null) {
            try {
                InputStream in = resultSet.getClob("MENSAJE_ES_012").getAsciiStream();
                StringWriter w = new StringWriter();
                IOUtils.copy(in, w);
                configuracion.setMensajeEs(w.toString());
            } catch (Exception e) {
                throw new Y41eRuntimeException(e);
            }
        }
        if (resultSet.getClob("MENSAJE_EU_012") != null) {
            try {
                InputStream in = resultSet.getClob("MENSAJE_EU_012").getAsciiStream();
                StringWriter w = new StringWriter();
                IOUtils.copy(in, w);
                configuracion.setMensajeEu(w.toString());
            } catch (Exception e) {
                throw new Y41eRuntimeException(e);
            }
        }
        return configuracion;
    }

}
