package com.ejie.y41e.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41e.model.Y41eTipoRespuesta;
import com.ejie.y41e.utils.Y41eSqlUtils;

/**
 * Y41eTipoRespuestaDaoImpl
 *  
 */

/**
 *  
 *
 */
@Repository
@Transactional
public class Y41eTipoRespuestaDaoImpl extends Y41eGenericoDaoImpl<Y41eTipoRespuesta> implements Y41eTipoRespuestaDao {

    private static final String TABLA="Y41E09S01";
    private static final String ID_TIPO_RESPUESTA_009 ="ID_TIPO_RESPUESTA_009";
    private static final String ID_TIPO_PREGUNTA_009 ="ID_TIPO_PREGUNTA_009";
    private static final String DESC_ES_009 ="DESC_ES_009";
    private static final String DESC_EU_009 ="DESC_EU_009";
    private static final String ORDEN_009 ="ORDEN_009";
    private static final String ACTIVA_009 ="ACTIVA_009";
    protected static final String[] ORDER_BY_WHITE_LIST = new String[] { ID_TIPO_RESPUESTA_009, ID_TIPO_PREGUNTA_009, DESC_ES_009, DESC_EU_009,
            ORDEN_009, ACTIVA_009};

    /**
     * Y41eTipoRespuestaDaoImpl
     */
    public Y41eTipoRespuestaDaoImpl() {
        super(Y41eTipoRespuesta.class);
    }

    /**
     * rwMap
     */
    private final RowMapper<Y41eTipoRespuesta> rwMap = new RowMapper<Y41eTipoRespuesta>() {
        @Override
        public Y41eTipoRespuesta mapRow(ResultSet resultSet, int rowNum) throws SQLException {
            Y41eTipoRespuesta tipoRespuesta = new Y41eTipoRespuesta();
            tipoRespuesta.setIdTipoRespuesta(resultSet.getLong(ID_TIPO_RESPUESTA_009));
            tipoRespuesta.getTipoPregunta().setIdTipoPregunta(resultSet.getLong(ID_TIPO_PREGUNTA_009));
            tipoRespuesta.setDescEs(resultSet.getString(DESC_ES_009));
            tipoRespuesta.setDescEu(resultSet.getString(DESC_EU_009));
            tipoRespuesta.setActiva(resultSet.getString(ACTIVA_009));
            tipoRespuesta.setOrden(resultSet.getLong(ORDEN_009));
            return tipoRespuesta;
        }
    };

    /* (non-Javadoc)
     * @see com.ejie.y41e.dao.Y41eGenericoDaoImpl#getSelect()
     */
    @Override
    protected String getSelect() {
        StringBuilder select = new StringBuilder("SELECT ")
                .append(ID_TIPO_RESPUESTA_009).append(",")
                .append(ID_TIPO_PREGUNTA_009).append(",")
                .append(DESC_ES_009).append(",")
                .append(DESC_EU_009).append(",")
                .append(ORDEN_009).append(",")
                .append(ACTIVA_009);
        return select.toString();
    }

    /* (non-Javadoc)
     * @see com.ejie.y41e.dao.Y41eGenericoDaoImpl#getFrom()
     */
    @Override
    protected String getFrom() {
        StringBuilder from = new StringBuilder(" FROM ").append(TABLA);
        return from.toString();
    }

    /* (non-Javadoc)
     * @see com.ejie.y41e.dao.Y41eGenericoDaoImpl#getWhereLike(java.lang.Object, java.lang.Boolean, java.util.List, java.lang.Boolean)
     */
    @Override
    protected String getWhereLike(Y41eTipoRespuesta bean, Boolean startsWith, List<Object> params, Boolean search) {
        StringBuilder where = new StringBuilder(Y41eTipoRespuestaDaoImpl.STRING_BUILDER_INIT);

        if (bean  != null){
            where.append(Y41eSqlUtils.generarWhereIgual(ID_TIPO_PREGUNTA_009, bean.getIdTipoRespuesta(), params));
            where.append(Y41eSqlUtils.generarWhereIgual(ID_TIPO_PREGUNTA_009, bean.getTipoPregunta().getIdTipoPregunta(), params));
            where.append(Y41eSqlUtils.generarWhereLikeNormalizado(DESC_ES_009, bean.getDescEs(), params, startsWith));
            where.append(Y41eSqlUtils.generarWhereLikeNormalizado(DESC_EU_009, bean.getDescEu(), params, startsWith));
            where.append(Y41eSqlUtils.generarWhereIgual(ACTIVA_009, bean.getActiva(), params));
        }
        return where.toString();
    }

    /**
     * Obtiene las respuestas según el tipo de pregunta
     * @param tipoRespuesta Y41eTipoRespuesta
     * @return List<Y41eTipoRespuesta>
     */
    @Override
    public List<Y41eTipoRespuesta> findAllRespuesta(Y41eTipoRespuesta tipoRespuesta){
        List<Object> params = new ArrayList<Object>();
        StringBuilder query = new StringBuilder(this.getSelect());
        query.append(this.getFrom());
        query.append(Y41eSqlUtils.DEFAULT_WHERE);
        query.append(this.getWhereLike(tipoRespuesta, false, params, false));
        query.append(Y41eSqlUtils.ORDER_BY);
        query.append(ORDEN_009).append(" ASC");
        return this.getJdbcTemplate().query(query.toString(), this.getRwMap(), params.toArray());
    }


    /**
     * StringBuilder initilization value
     */
    public static final int STRING_BUILDER_INIT = 4096;

    /* (non-Javadoc)
     * @see com.ejie.y41e.dao.Y41eGenericoDaoImpl#getRwMap()
     */
    @Override
    protected RowMapper<Y41eTipoRespuesta> getRwMap() {
        return rwMap;
    }

    /* (non-Javadoc)
     * @see com.ejie.y41e.dao.Y41eGenericoDaoImpl#getPK()
     */
    @Override
    protected String getPK() {
        return null;
    }

    /* (non-Javadoc)
     * @see com.ejie.y41e.dao.Y41eGenericoDaoImpl#getRwMapPK()
     */
    @Override
    protected RowMapper<Y41eTipoRespuesta> getRwMapPK() {
        return null;
    }

    /* (non-Javadoc)
     * @see com.ejie.y41e.dao.Y41eGenericoDaoImpl#getWherePK(java.lang.Object, java.util.List)
     */
    @Override
    protected String getWherePK(Y41eTipoRespuesta bean, List<Object> params) {
        return null;
    }

    /* (non-Javadoc)
     * @see com.ejie.y41e.dao.Y41eGenericoDaoImpl#getWhere(java.lang.Object, java.util.List)
     */
    @Override
    protected String getWhere(Y41eTipoRespuesta bean, List<Object> params) {
        StringBuilder where = new StringBuilder(Y41eTipoRespuestaDaoImpl.STRING_BUILDER_INIT);

        if (bean  != null){
            where.append(Y41eSqlUtils.generarWhereIgual(ID_TIPO_PREGUNTA_009, bean.getIdTipoRespuesta(), params));
            where.append(Y41eSqlUtils.generarWhereIgual(ID_TIPO_PREGUNTA_009, bean.getTipoPregunta().getIdTipoPregunta(), params));
            where.append(Y41eSqlUtils.generarWhereIgual(DESC_ES_009, bean.getDescEs(), params));
            where.append(Y41eSqlUtils.generarWhereIgual(DESC_EU_009, bean.getDescEu(), params));
            where.append(Y41eSqlUtils.generarWhereIgual(ACTIVA_009, bean.getActiva(), params));
        }
        return where.toString();
    }

    /* (non-Javadoc)
     * @see com.ejie.y41e.dao.Y41eGenericoDaoImpl#getOrderBy()
     */
    @Override
    protected String[] getOrderBy() {
        return Y41eTipoRespuestaDaoImpl.ORDER_BY_WHITE_LIST;
    }
}
