package com.ejie.y41e.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41e.model.Y41eTipoPregunta;
import com.ejie.y41e.utils.Y41eSqlUtils;

/**
 * Y41eTipoPreguntaDaoImpl
 *  
 */

@Repository
@Transactional
public class Y41eTipoPreguntaDaoImpl extends Y41eGenericoDaoImpl<Y41eTipoPregunta> implements Y41eTipoPreguntaDao {

    public static final String TABLA="Y41E08S01";
    public static final String SECUENCIA="Y41E04Q00";
    public static final String ID_TIPO_PREGUNTA_008 ="ID_TIPO_PREGUNTA_008";
    public static final String DESC_ES_008 ="DESC_ES_008";
    public static final String DESC_EU_008 ="DESC_EU_008";
    public static final String ACTIVA_008 ="ACTIVA_008";
    protected static final String[] ORDER_BY_WHITE_LIST = new String[] { ID_TIPO_PREGUNTA_008, DESC_ES_008, DESC_EU_008, ACTIVA_008};

    /**
     * Y41eTipoPreguntaDaoImpl
     */
    public Y41eTipoPreguntaDaoImpl() {
        super(Y41eTipoPregunta.class);
    }

    /*
     * ROW_MAPPERS
     */
    private final RowMapper<Y41eTipoPregunta> rwMap = new RowMapper<Y41eTipoPregunta>() {
        @Override
        public Y41eTipoPregunta mapRow(ResultSet resultSet, int rowNum) throws SQLException {
            Y41eTipoPregunta tipoPregunta = new Y41eTipoPregunta();
            tipoPregunta.setIdTipoPregunta(resultSet.getLong(ID_TIPO_PREGUNTA_008));
            tipoPregunta.setDescEs(resultSet.getString(DESC_ES_008));
            tipoPregunta.setDescEu(resultSet.getString(DESC_EU_008));
            tipoPregunta.setActiva(resultSet.getString(ACTIVA_008));
            return tipoPregunta;
        }
    };

    private final RowMapper<Y41eTipoPregunta> rwMapPK = new RowMapper<Y41eTipoPregunta>() {
        @Override
        public Y41eTipoPregunta mapRow(ResultSet resultSet, int rowNum) throws SQLException {
            return new Y41eTipoPregunta(resultSet.getLong(ID_TIPO_PREGUNTA_008)); 
        }
    };

    /* (non-Javadoc)
     * @see com.ejie.y41e.dao.Y41eGenericoDaoImpl#getSelect()
     */
    @Override
    protected String getSelect() {
        StringBuilder select = new StringBuilder("SELECT ")
                .append(ID_TIPO_PREGUNTA_008).append(",")
                .append(DESC_ES_008).append(",")
                .append(DESC_EU_008).append(",")
                .append(ACTIVA_008);
        return select.toString();
    }

    /* (non-Javadoc)
     * @see com.ejie.y41e.dao.Y41eGenericoDaoImpl#getFrom()
     */
    @Override
    protected String getFrom() {
        StringBuilder from = new StringBuilder(" FROM ").append(TABLA);
        return from.toString();
    }

    /* (non-Javadoc)
     * @see com.ejie.y41e.dao.Y41eGenericoDaoImpl#getRwMap()
     */
    @Override
    protected RowMapper<Y41eTipoPregunta> getRwMap() {
        return this.rwMap;
    }

    /* (non-Javadoc)
     * @see com.ejie.y41e.dao.Y41eGenericoDaoImpl#getPK()
     */
    @Override
    protected String getPK() {
        return ID_TIPO_PREGUNTA_008;
    }

    /* (non-Javadoc)
     * @see com.ejie.y41e.dao.Y41eGenericoDaoImpl#getRwMapPK()
     */
    @Override
    protected RowMapper<Y41eTipoPregunta> getRwMapPK() {
        return this.rwMapPK;
    }

    /* (non-Javadoc)
     * @see com.ejie.y41e.dao.Y41eGenericoDaoImpl#getWherePK(java.lang.Object, java.util.List)
     */
    @Override
    protected String getWherePK(Y41eTipoPregunta bean, List<Object> params) {
        StringBuilder wherePK = new StringBuilder();
        wherePK.append(Y41eSqlUtils.WHERE).append(ID_TIPO_PREGUNTA_008).append("=?");
        params.add(bean.getIdTipoPregunta());
        return wherePK.toString();

    }

    /* (non-Javadoc)
     * @see com.ejie.y41e.dao.Y41eGenericoDaoImpl#getWhere(java.lang.Object, java.util.List)
     */
    @Override
    protected String getWhere(Y41eTipoPregunta bean, List<Object> params) {
        StringBuilder where = new StringBuilder(Y41eTipoPreguntaDaoImpl.STRING_BUILDER_INIT);

        if (bean  != null){
            where.append(Y41eSqlUtils.generarWhereIgual(ID_TIPO_PREGUNTA_008, bean.getIdTipoPregunta(), params));
            where.append(Y41eSqlUtils.generarWhereIgual(DESC_ES_008, bean.getDescEs(), params));
            where.append(Y41eSqlUtils.generarWhereIgual(DESC_EU_008, bean.getDescEu(), params));
            where.append(Y41eSqlUtils.generarWhereIgual(ACTIVA_008, bean.getActiva(), params));
        }

        return where.toString();
    }

    /* (non-Javadoc)
     * @see com.ejie.y41e.dao.Y41eGenericoDaoImpl#getWhereLike(java.lang.Object, java.lang.Boolean, java.util.List, java.lang.Boolean)
     */
    @Override
    protected String getWhereLike(Y41eTipoPregunta bean, Boolean startsWith, List<Object> params, Boolean search) {
        StringBuilder where = new StringBuilder(Y41eTipoPreguntaDaoImpl.STRING_BUILDER_INIT);

        if (bean  != null){
            where.append(Y41eSqlUtils.generarWhereIgual(ID_TIPO_PREGUNTA_008, bean.getIdTipoPregunta(), params));
            where.append(Y41eSqlUtils.generarWhereLikeNormalizado(DESC_ES_008, bean.getDescEs(), params, startsWith));
            where.append(Y41eSqlUtils.generarWhereLikeNormalizado(DESC_EU_008, bean.getDescEu(), params, startsWith));
            where.append(Y41eSqlUtils.generarWhereIgual(ACTIVA_008, bean.getActiva(), params));
        }
        return where.toString();
    }

    /* (non-Javadoc)
     * @see com.ejie.y41e.dao.Y41eGenericoDaoImpl#getOrderBy()
     */
    @Override
    protected String[] getOrderBy() {
        return Y41eTipoPreguntaDaoImpl.ORDER_BY_WHITE_LIST;
    }


    /**
     * StringBuilder initilization value
     */
    public static final int STRING_BUILDER_INIT = 4096;
}
