package com.ejie.y41e.dao;

import java.util.List;

import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.y41e.model.Y41eEncuesta;
import com.ejie.y41e.model.Y41eEnvio;
import com.ejie.y41e.model.Y41eResultados;

/**
 * Y41eResultadosDao
 *  
 */

public interface Y41eResultadosDao extends Y41eGenericoDao<Y41eResultados>{

    /**
     * Devuelve los resultados por encuesta
     * @param filterEncuesta Y41eEncuesta
     * @param jqGridRequestDto JQGridRequestDto
     * @param startsWith boolean
     * @return List<Y41eEncuesta>
     */
    public List<Y41eEncuesta> findAllLikeEncuestas(Y41eEncuesta filterEncuesta, JQGridRequestDto jqGridRequestDto,
            boolean startsWith);

    /**
     * Obtiene el número de resultados por encuestas
     * @param filterEncuesta Y41eEncuesta
     * @param startsWith boolean 
     * @return Long
     */
    public Long findAllLikeCountEncuestas(Y41eEncuesta filterEncuesta, boolean startsWith);

    /**
     * Obtien las respuestas y los resultados de cada una
     * @param resultado Y41eResultados
     * @param idBloque Long
     * @param idPregunta Long
     * @return List<Y41eResultados>
     */
    public List<Y41eResultados> getResultadosPreguntas(Y41eResultados resultado, Long idBloque, Long idPregunta);

    /**
     * Obtiene los resultados de las preguntas de tipo texto
     * @param resultado Y41eResultados
     * @param idBloque Long
     * @param idPregunta Long
     * @return ist<Y41eResultados>
     */
    public List<Y41eResultados> getResultadosPreguntasTexto(Y41eResultados resultado, Long idBloque, Long idPregunta);

    /**
     * Devuelve los resultados por destinatario
     * @param filter Y41eEnvio
     * @param jqGridRequestDto JQGridRequestDto
     * @param startsWith boolean
     * @return List<Y41eEnvio>
     */
    public List<Y41eEnvio> findAllLikeDestinatario(Y41eEnvio filter, JQGridRequestDto jqGridRequestDto, boolean startsWith);

    /**
     * Obtiene el número de resultados por destinatario
     * @param filter Y41eEnvio
     * @param startsWith boolean
     * @return Long
     */
    public Long findAllLikeCountDestinatarios(Y41eEnvio filter, boolean startsWith);

    /**
     * Obtiene los resultados de la encuesta para el usuario indicado
     * @param envio Y41eEnvio
     * @return List<Y41eResultados>
     */
    public List<Y41eResultados> getResultadosDestinatario(Y41eEnvio envio);

    /**
     * Guardar las respuestas del usuario
     * @param encuesta Y41eEncuesta
     * @param idEnvio Long
     */
    public void guardarRespuestas(Y41eEncuesta encuesta, Long idEnvio);

}

