package com.ejie.y41e.dao;

import java.util.List;

import com.ejie.y41e.model.Y41eBloque;
import com.ejie.y41e.model.Y41eEncuesta;
import com.ejie.y41e.model.Y41eRelEncuestaBloque;

/**
 * RelEncuestaBloqueDao
 *  
 */

public interface Y41eRelEncuestaBloqueDao extends Y41eGenericoDao<Y41eRelEncuestaBloque>{

    /**
     * Obtiene el siguiente orden 
     * @param idEncuesta Long
     * @return Long
     */
    public Long getSigOrden(Long idEncuesta);

    /**
     * Asocia los bloques seleccionados a la encuesta
     * @param idEncuesta Long
     * @param listaBloquesSeleccionados List<Y41eBloque>
     */
    public void asosiarBloques(Long idEncuesta, List<Y41eBloque> listaBloquesSeleccionados);

    /**
     * Ordena las bloques según el orden pasado
     * @param orden String
     * @param idEncuesta String
     */
    public void moverBloque(String orden, String idEncuesta);

    /**
     * Copiar los bloques de una encuesta a otra
     * @param idEncuestaOrigen Long
     * @param idEncuestaCopiar Long
     */
    public void copiarBloques(Long idEncuestaOrigen, Long idEncuestaCopiar);

    /**
     * Obtiene los bloques de la encuesta en orden
     * @param encuesta Y41eEncuesta
     * @return List<Y41eBloque>
     */
    public List<Y41eBloque> getBloquesWeb(Y41eEncuesta encuesta);

}

