package com.ejie.y41e.dao;

import java.util.List;

import com.ejie.y41e.model.Y41eBloque;
import com.ejie.y41e.model.Y41eEncuesta;
import com.ejie.y41e.model.Y41ePregunta;
import com.ejie.y41e.model.Y41eRelBloquePregunta;

/**
 * Y41eRelBloquePreguntaDao
 *  
 */

public interface Y41eRelBloquePreguntaDao extends Y41eGenericoDao<Y41eRelBloquePregunta>{

    /**
     * Copia las preguntas de un bloque a otro
     * @param idBloque Long
     * @param idBloqueCopiar Long
     */
    public void copiarPreguntas(Long idBloque, Long idBloqueCopiar);

    /**
     * Obtiene el siguiente orden 
     * @param idBloque Long
     * @return Long
     */
    public Long getSigOrden(Long idBloque);

    /**
     * Asocia las preguntas al bloque indicado
     * @param idBloque Long
     * @param listaPreguntasSeleccionadas List<Y41ePregunta>
     */
    public void asosiarPreguntas(Long idBloque, List<Y41ePregunta> listaPreguntasSeleccionadas);

    /**
     * Ordena las pregutnas según el orden pasado
     *
     * @param ordenIds String
     * @param idBloque String
     */
    public void moverPregunta(String ordenIds, String idBloque);

    /**
     * Obtiene los bloques de la encuesta en orden
     * @param bloque Y41eBloque
     * @param encuesta Y41eEncuesta
     * @return List<Y41eBloque>
     */
    public List<Y41ePregunta> getPreguntasWeb(Y41eBloque bloque, Y41eEncuesta encuesta);

}

