package com.ejie.y41e.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41e.common.Y41eConstants;
import com.ejie.y41e.model.Y41ePreguntaEnlazada;
import com.ejie.y41e.utils.Y41eSqlUtils;

/**
 * Y41ePreguntaEnlazadaDaoImpl
 *  
 */

/**
 *  
 *
 */
@Repository
@Transactional
public class Y41ePreguntaEnlazadaDaoImpl extends Y41eGenericoDaoImpl<Y41ePreguntaEnlazada> implements Y41ePreguntaEnlazadaDao {

    private static final String TABLA="Y41E14S01";
    private static final String ID_ENCUESTA_014 ="ID_ENCUESTA_014";
    private static final String ID_BLOQUE_014 ="ID_BLOQUE_014";
    private static final String ID_PREGUNTA_014 ="ID_PREGUNTA_014";
    private static final String ID_ENLAZADA_014 ="ID_ENLAZADA_014";
    private static final String TIPO_014 ="TIPO_014";
    protected static final String[] ORDER_BY_WHITE_LIST = new String[] { ID_ENCUESTA_014, ID_BLOQUE_014, ID_PREGUNTA_014, ID_ENLAZADA_014, TIPO_014 };

    /**
     * Y41ePreguntaEnlazada
     */
    public Y41ePreguntaEnlazadaDaoImpl() {
        super(Y41ePreguntaEnlazada.class);
    }

    /**
     * rwPreguntaEnlazadaMap
     */
    private final RowMapper<Y41ePreguntaEnlazada> rwPreguntaEnlazadaMap = new RowMapper<Y41ePreguntaEnlazada>() {
        @Override
        public Y41ePreguntaEnlazada mapRow(ResultSet resultSet, int rowNum) throws SQLException {
            Y41ePreguntaEnlazada preguntaEnlazada = new Y41ePreguntaEnlazada();
            preguntaEnlazada.setIdPregunta(resultSet.getLong(ID_PREGUNTA_014));
            preguntaEnlazada.setIdBloque(resultSet.getLong(ID_BLOQUE_014));
            preguntaEnlazada.setIdEncuesta(resultSet.getLong(ID_ENCUESTA_014));
            preguntaEnlazada.setIdEnlazada(resultSet.getLong(ID_ENLAZADA_014));
            preguntaEnlazada.setTipo(resultSet.getString(TIPO_014));
            preguntaEnlazada.setSeleccionada(resultSet.getString("SELECCIONADO"));
            preguntaEnlazada.setDescIntEs(resultSet.getString("DESC_INT_ES"));
            preguntaEnlazada.setDescIntEu(resultSet.getString("DESC_INT_EU"));
            preguntaEnlazada.setDescPublEs(resultSet.getString("DESC_PUBL_ES"));
            preguntaEnlazada.setDescPublEu(resultSet.getString("DESC_PUBL_EU"));
            return preguntaEnlazada;
        }
    };


    /* (non-Javadoc)
     * @see com.ejie.y41e.dao.Y41eGenericoDaoImpl#getSelect()
     */
    @Override
    protected String getSelect() {
        StringBuilder select = new StringBuilder("SELECT ")
                .append(ID_PREGUNTA_014).append(",")
                .append(ID_ENLAZADA_014).append(",")
                .append(TIPO_014);
        return select.toString();
    }

    /* (non-Javadoc)
     * @see com.ejie.y41e.dao.Y41eGenericoDaoImpl#getFrom()
     */
    @Override
    protected String getFrom() {
        StringBuilder from = new StringBuilder(" FROM ").append(TABLA);
        return from.toString();
    }

    /* (non-Javadoc)
     * @see com.ejie.y41e.dao.Y41eGenericoDaoImpl#getWhereLike(java.lang.Object, java.lang.Boolean, java.util.List, java.lang.Boolean)
     */
    @Override
    protected String getWhereLike(Y41ePreguntaEnlazada bean, Boolean startsWith, List<Object> params, Boolean search) {
        return null;
    }

    /**
     * StringBuilder initilization value
     */
    public static final int STRING_BUILDER_INIT = 4146;

    /* (non-Javadoc)
     * @see com.ejie.y41e.dao.Y41eGenericoDaoImpl#getRwMap()
     */
    @Override
    protected RowMapper<Y41ePreguntaEnlazada> getRwMap() {
        return null;
    }

    /* (non-Javadoc)
     * @see com.ejie.y41e.dao.Y41eGenericoDaoImpl#getPK()
     */
    @Override
    protected String getPK() {
        return null;
    }

    /* (non-Javadoc)
     * @see com.ejie.y41e.dao.Y41eGenericoDaoImpl#getRwMapPK()
     */
    @Override
    protected RowMapper<Y41ePreguntaEnlazada> getRwMapPK() {
        return null;
    }

    /* (non-Javadoc)
     * @see com.ejie.y41e.dao.Y41eGenericoDaoImpl#getWherePK(java.lang.Object, java.util.List)
     */
    @Override
    protected String getWherePK(Y41ePreguntaEnlazada bean, List<Object> params) {
        return null;
    }

    /* (non-Javadoc)
     * @see com.ejie.y41e.dao.Y41eGenericoDaoImpl#getWhere(java.lang.Object, java.util.List)
     */
    @Override
    protected String getWhere(Y41ePreguntaEnlazada bean, List<Object> params) {
        return null;
    }

    /* (non-Javadoc)
     * @see com.ejie.y41e.dao.Y41eGenericoDaoImpl#getOrderBy()
     */
    @Override
    protected String[] getOrderBy() {
        return Y41ePreguntaEnlazadaDaoImpl.ORDER_BY_WHITE_LIST;
    }

    /**
     * Obtiene las preguntas o bloques enlazados
     * @param idPreguntaPadre Long
     * @param idBloqueEnlazar Long
     * @param idEncuestaEnlazar Long
     * @return List<Y41ePreguntaEnlazada>
     */
    @Override
    public List<Y41ePreguntaEnlazada> findTreeEnlazadas(Long idPreguntaPadre, Long idBloqueEnlazar, Long idEncuestaEnlazar){
        List<Object> params = new ArrayList<Object>();
        StringBuilder select = new StringBuilder(Y41ePreguntaEnlazadaDaoImpl.STRING_BUILDER_INIT);
        select.append(Y41eSqlUtils.SELECT)
        .append(Y41eSqlUtils.NVL).append("(").append(ID_PREGUNTA_014).append(",")
        .append(idPreguntaPadre).append(")").append(ID_PREGUNTA_014).append(",")
        .append(Y41eSqlUtils.NVL).append("(").append(ID_BLOQUE_014).append(",")
        .append(idBloqueEnlazar).append(")").append(ID_BLOQUE_014).append(",")
        .append(Y41eSqlUtils.NVL).append("(").append(ID_ENCUESTA_014).append(",")
        .append(idEncuestaEnlazar).append(")").append(ID_ENCUESTA_014).append(",")
        .append(Y41eSqlUtils.NVL).append("(").append(ID_ENLAZADA_014).append(", ID_PREGUNTA_004)")
        .append(ID_ENLAZADA_014).append(",")
        .append(Y41eSqlUtils.NVL).append("(").append(TIPO_014).append(",'")
        .append(Y41eConstants.TIPO_PREGUNTA).append("')")
        .append(TIPO_014).append(",")
        .append(Y41eSqlUtils.NVL2).append("(").append(TIPO_014).append(",'")
        .append(Y41eConstants.SI).append("','").append(Y41eConstants.NO).append("')")
        .append(" SELECCIONADO").append(",")
        .append(" DESC_PUBL_ES_004 DESC_PUBL_ES, DESC_INT_ES_004 DESC_INT_ES,")
        .append(" DESC_PUBL_EU_004 DESC_PUBL_EU, DESC_INT_EU_004 DESC_INT_EU,")
        .append(" ORDEN_PREG_005 ORDEN")
        .append(Y41eSqlUtils.FROM).append("Y41E04S01")
        .append(Y41eSqlUtils.JOIN).append("Y41E05S01 ON ID_PREGUNTA_004=ID_PREGUNTA_005")
        .append(Y41eSqlUtils.LEFT_JOIN).append(TABLA).append(" ON ID_PREGUNTA_004=").append(ID_ENLAZADA_014)
        .append(Y41eSqlUtils.AND).append(ID_ENCUESTA_014).append("=").append(idEncuestaEnlazar)
        .append(Y41eSqlUtils.AND).append(ID_PREGUNTA_014).append("=").append(idPreguntaPadre)
        .append(Y41eSqlUtils.AND).append(ID_BLOQUE_014).append("=").append(idBloqueEnlazar)
        .append(Y41eSqlUtils.AND).append(TIPO_014).append("='").append(Y41eConstants.TIPO_PREGUNTA).append("'")
        .append(Y41eSqlUtils.LEFT_JOIN).append(" (").append(Y41eSqlUtils.SELECT)
        .append(" ID_PREGUNTA_005 ID_PREGUNTA_PADRE, ID_BLOQUE_005 ID_BLOQUE_PADRE, ORDEN_PREG_005 ORDEN_PADRE")
        .append(Y41eSqlUtils.FROM).append("Y41E05S01) ON ")
        .append(" ID_BLOQUE_PADRE=").append(idBloqueEnlazar)
        .append(Y41eSqlUtils.AND).append(" ID_PREGUNTA_PADRE=").append(idPreguntaPadre)
        .append(Y41eSqlUtils.WHERE).append("ID_BLOQUE_005=?")
        .append(Y41eSqlUtils.AND).append("ORDEN_PREG_005>ORDEN_PADRE")
        .append(Y41eSqlUtils.AND).append("ID_PREGUNTA_004!=?")
        .append(Y41eSqlUtils.AND).append(Y41eSqlUtils.NOT_EXISTS).append(Y41eSqlUtils.SELECT_1)
        .append(Y41eSqlUtils.FROM).append(TABLA)
        .append(Y41eSqlUtils.WHERE).append(ID_PREGUNTA_014).append("=ID_PREGUNTA_004")
        .append(Y41eSqlUtils.AND).append(ID_ENCUESTA_014).append("=").append(idEncuestaEnlazar)
        .append(Y41eSqlUtils.AND).append(TIPO_014).append("='").append(Y41eConstants.TIPO_PREGUNTA).append("')")
        .append(Y41eSqlUtils.AND).append(Y41eSqlUtils.NOT_EXISTS).append(Y41eSqlUtils.SELECT_1)
        .append(Y41eSqlUtils.FROM).append(TABLA)
        .append(Y41eSqlUtils.WHERE).append(ID_ENLAZADA_014).append("=ID_PREGUNTA_004")
        .append(Y41eSqlUtils.AND).append(ID_PREGUNTA_014).append("!=").append(idPreguntaPadre)
        .append(Y41eSqlUtils.AND).append(ID_ENCUESTA_014).append("=").append(idEncuestaEnlazar)
        .append(Y41eSqlUtils.AND).append(TIPO_014).append("='").append(Y41eConstants.TIPO_PREGUNTA).append("')");

        params.add(idBloqueEnlazar);
        params.add(idPreguntaPadre);

        select.append(" UNION ")
        .append(Y41eSqlUtils.SELECT)
        .append(Y41eSqlUtils.NVL).append("(").append(ID_PREGUNTA_014).append(",")
        .append(idPreguntaPadre).append(")").append(ID_PREGUNTA_014).append(",")
        .append(Y41eSqlUtils.NVL).append("(").append(ID_BLOQUE_014).append(",")
        .append(idBloqueEnlazar).append(")").append(ID_BLOQUE_014).append(",")
        .append(Y41eSqlUtils.NVL).append("(").append(ID_ENCUESTA_014).append(",")
        .append(idEncuestaEnlazar).append(")").append(ID_ENCUESTA_014).append(",")
        .append(Y41eSqlUtils.NVL).append("(").append(ID_ENLAZADA_014).append(", ID_BLOQUE_002)")
        .append(ID_ENLAZADA_014).append(",")
        .append(Y41eSqlUtils.NVL).append("(").append(TIPO_014).append(",'")
        .append(Y41eConstants.TIPO_BLOQUE).append("')")
        .append(TIPO_014).append(",")
        .append(Y41eSqlUtils.NVL2).append("(").append(TIPO_014).append(",'")
        .append(Y41eConstants.SI).append("','").append(Y41eConstants.NO).append("')")
        .append(" SELECCIONADO").append(",")
        .append(" DESC_PUBL_ES_002 DESC_PUBL_ES, DESC_INT_ES_002 DESC_INT_ES,")
        .append(" DESC_PUBL_EU_002 DESC_PUBL_EU, DESC_INT_EU_002 DESC_INT_EU,")
        .append(" ORDEN_BLOQ_003 ORDEN")
        .append(Y41eSqlUtils.FROM).append("Y41E02S01")
        .append(Y41eSqlUtils.JOIN).append("Y41E03S01 ON ID_BLOQUE_002=ID_BLOQUE_003")
        .append(Y41eSqlUtils.LEFT_JOIN).append(TABLA).append(" ON ID_BLOQUE_002=").append(ID_ENLAZADA_014)
        .append(Y41eSqlUtils.AND).append(ID_ENCUESTA_014).append("=").append(idEncuestaEnlazar)
        .append(Y41eSqlUtils.AND).append(ID_PREGUNTA_014).append("=").append(idPreguntaPadre)
        .append(Y41eSqlUtils.AND).append(ID_BLOQUE_014).append("=").append(idBloqueEnlazar)
        .append(Y41eSqlUtils.AND).append(TIPO_014).append("='").append(Y41eConstants.TIPO_BLOQUE).append("'")
        .append(Y41eSqlUtils.LEFT_JOIN).append(" (").append(Y41eSqlUtils.SELECT)
        .append(" ID_BLOQUE_003 ID_BLOQUE_PADRE, ORDEN_BLOQ_003 ORDEN_PADRE")
        .append(Y41eSqlUtils.FROM).append("Y41E03S01) ON ")
        .append(" ID_BLOQUE_PADRE=").append(idBloqueEnlazar)
        .append(Y41eSqlUtils.WHERE).append("ID_ENCUESTA_003=?")
        .append(Y41eSqlUtils.AND).append("ORDEN_BLOQ_003>ORDEN_PADRE")
        .append(Y41eSqlUtils.AND).append("ID_BLOQUE_002!=?")
        .append(Y41eSqlUtils.AND).append(Y41eSqlUtils.NOT_EXISTS).append(Y41eSqlUtils.SELECT_1)
        .append(Y41eSqlUtils.FROM).append(TABLA)
        .append(Y41eSqlUtils.WHERE).append(ID_BLOQUE_014).append("=ID_BLOQUE_002")
        .append(Y41eSqlUtils.AND).append(ID_ENCUESTA_014).append("=ID_ENCUESTA_003")
        .append(Y41eSqlUtils.AND).append(TIPO_014).append("='").append(Y41eConstants.TIPO_BLOQUE).append("')")
        .append(Y41eSqlUtils.AND).append(Y41eSqlUtils.NOT_EXISTS).append(Y41eSqlUtils.SELECT_1)
        .append(Y41eSqlUtils.FROM).append(TABLA)
        .append(Y41eSqlUtils.WHERE).append(ID_ENLAZADA_014).append("=ID_BLOQUE_002")
        .append(Y41eSqlUtils.AND).append(ID_PREGUNTA_014).append("!=").append(idPreguntaPadre)
        .append(Y41eSqlUtils.AND).append(ID_ENCUESTA_014).append("=ID_ENCUESTA_003")
        .append(Y41eSqlUtils.AND).append(TIPO_014).append("='").append(Y41eConstants.TIPO_BLOQUE).append("')");

        params.add(idEncuestaEnlazar);
        params.add(idBloqueEnlazar);
        select.append(Y41eSqlUtils.ORDER_BY).append(TIPO_014).append(" DESC, ORDEN ASC");

        return this.getJdbcTemplate().query(select.toString(), this.rwPreguntaEnlazadaMap ,params.toArray());
    }

    /**
     * Removes a single row in the Area table.
     *
     * @param area Area
     * @return
     */
    @Override
    public void remove(Y41ePreguntaEnlazada preguntaEnlazada) {
        StringBuilder delete = new StringBuilder(Y41eSqlUtils.DELETE).append(TABLA)
                .append(Y41eSqlUtils.WHERE).append(ID_ENCUESTA_014).append("=?")
                .append(Y41eSqlUtils.AND).append(ID_BLOQUE_014).append("=?")
                .append(Y41eSqlUtils.AND).append(ID_PREGUNTA_014).append("=?");
        this.getJdbcTemplate().update(delete.toString(), preguntaEnlazada.getIdEncuesta(), preguntaEnlazada.getIdBloque(), preguntaEnlazada.getIdPregunta());
    }

    @Override
    /**
     * Eliminas las preguntas enlazadas de un bloque
     * @param preguntaEnlazada Y41ePreguntaEnlazada
     */
    public void removeByBloque(Y41ePreguntaEnlazada preguntaEnlazada){
        StringBuilder deleteBloque = new StringBuilder(Y41eSqlUtils.DELETE).append(TABLA)
                .append(Y41eSqlUtils.WHERE).append(ID_ENCUESTA_014).append("=?")
                .append(Y41eSqlUtils.AND).append(ID_BLOQUE_014).append("=?");
        this.getJdbcTemplate().update(deleteBloque.toString(), preguntaEnlazada.getIdEncuesta(), preguntaEnlazada.getIdBloque());
    }

    /**
     * Guardar las preguntas o bloques asociados a una pregunta
     * @param selectedIds List<String>
     */
    @Override
    public void addEnlazadas(List<String> selectedIds){
        StringBuilder insert = new StringBuilder(Y41eSqlUtils.INSERT)
                .append(TABLA).append(" (")
                .append(ID_ENCUESTA_014).append(",")
                .append(ID_BLOQUE_014).append(",")
                .append(ID_PREGUNTA_014).append(",")
                .append(ID_ENLAZADA_014).append(",")
                .append(TIPO_014).append(")")
                .append("VALUES (?,?,?,?,?)");

        final List<Object[]> paramsInsert = new ArrayList<Object[]>();
        List<Object> auxInsert = new ArrayList<Object>();
        for(String id:selectedIds){
            auxInsert.clear();
            if(id.split(Y41eConstants.SEPARADOR_OPTION).length>1){
                auxInsert.add(id.split(Y41eConstants.SEPARADOR_OPTION)[0]);
                auxInsert.add(id.split(Y41eConstants.SEPARADOR_OPTION)[1]);
                auxInsert.add(id.split(Y41eConstants.SEPARADOR_OPTION)[2]);
                auxInsert.add(id.split(Y41eConstants.SEPARADOR_OPTION)[3]);
                auxInsert.add(id.split(Y41eConstants.SEPARADOR_OPTION)[4]);
                paramsInsert.add(auxInsert.toArray().clone());
            }

        }
        this.getJdbcTemplate().batchUpdate(insert.toString(), paramsInsert);
    }

    /**
     * Copia las preguntas enlazadas de una encuesta a otra
     * @param idEncuestaOrigen Long
     * @param idEncuestaCopiar Long
     */
    @Override
    public void copiarPreguntasEnlazadas(Long idEncuestaOrigen, Long idEncuestaCopiar){
        StringBuilder sqlCopiar = new StringBuilder(Y41eRelBloquePreguntaDaoImpl.STRING_BUILDER_INIT);
        sqlCopiar.append(Y41eSqlUtils.INSERT).append(TABLA)
        .append(Y41eSqlUtils.SELECT).append(idEncuestaCopiar).append(", ")
        .append(ID_BLOQUE_014).append(",")
        .append(ID_PREGUNTA_014).append(",")
        .append(ID_ENLAZADA_014).append(",")
        .append(TIPO_014)
        .append(Y41eSqlUtils.FROM).append(TABLA)
        .append(Y41eSqlUtils.WHERE)
        .append(ID_ENCUESTA_014).append("=?");

        this.getJdbcTemplate().update(sqlCopiar.toString(), idEncuestaOrigen);
    }

}
