package com.ejie.y41e.dao;

import java.util.List;

import com.ejie.y41e.model.Y41ePreguntaEnlazada;

/**
 * Y41ePreguntaEnlazadaDao
 *  
 */

public interface Y41ePreguntaEnlazadaDao extends Y41eGenericoDao<Y41ePreguntaEnlazada>{

    /**
     * Obtiene las preguntas o bloques enlazados
     * @param idPreguntaPadre Long
     * @param idBloqueEnlazar Long
     * @param idEncuestaEnlazar Long
     * @return List<Y41ePreguntaEnlazada>
     */
    public List<Y41ePreguntaEnlazada> findTreeEnlazadas(Long idPreguntaPadre, Long idBloqueEnlazar, Long idEncuestaEnlazar);

    /**
     * Guardar las preguntas o bloques asociados a una pregunta
     * @param selectedIds List<String>
     */
    public void addEnlazadas(List<String> selectedIds);

    /**
     * Copia las preguntas enlazadas de una encuesta a otra
     * @param idEncuestaOrigen Long
     * @param idEncuestaCopiar Long
     */
    public void copiarPreguntasEnlazadas(Long idEncuestaOrigen, Long idEncuestaCopiar);

    /**
     * Eliminas las preguntas enlazadas de un bloque
     * @param preguntaEnlazada Y41ePreguntaEnlazada
     */
    public void removeByBloque(Y41ePreguntaEnlazada preguntaEnlazada);

}

