package com.ejie.y41e.dao;

import java.util.List;

import com.ejie.y41e.model.Y41ePregunta;

/**
 * Y41ePreguntaDao
 *  
 */

public interface Y41ePreguntaDao extends Y41eGenericoDao<Y41ePregunta>{

    /**
     * Comprueba que no existe ninguna encuesta enviada o respondida para el id de la pregunta.
     * @param idPregunta Long
     * @return El área o áreas a la que pertenece la encuesta
     */
    public Integer validarPreguntaEnviada(Long idPregunta);

    /**
     * Comprueba que el bloque no esté asociado a una encuesta enviada.
     * @param idBloque Long
     * @return Integer
     */
    public Integer validarDesasociarEnviada(Long idBloque);

    /**
     * Comprueba que el bloque no esté asociado a una encuesta.
     * @param idBloque Long
     * @return Integer
     */
    public Integer validarDesasociarEncuesta(Long idBloque);

    /**
     * Comprueba que la pregunta pertenece a una encuesta.
     * @param idPregunta Long
     * @return El área o áreas a la que pertenece la encuesta
     */
    public Integer validarPreguntaEncuesta(Long idPregunta);

    /**
     * Obtiene el suggest de bloques
     * @param pregunta Y41ePregunta
     * @param startsWith boolean
     * @return List<Y41ePregunta>
     */
    public List<Y41ePregunta> findAllSuggest(Y41ePregunta pregunta, boolean startsWith);

    /**
     * Añade las respuestas que generan aviso
     * @param bean Y41ePregunta
     */
    public void addRespuestasAviso(Y41ePregunta bean);

    /**
     * Obtiene las respuestas con aviso
     * @param bean Y41ePregunta
     * @return String
     */
    public String getRespuestasAviso(Y41ePregunta bean);

    /**
     * Eliminar los avisos de la pregunta
     * @param bean Y41ePregunta
     */
    public void removeRespuestasAviso(Y41ePregunta bean);

    /**
     * Devuelve la pregunta si tiene configurado avisos
     * @param idPregunta Long
     * @param idTipoRespuesta Long
     * @return Y41ePregunta
     */
    public Y41ePregunta findPreguntaAviso(Long idPregunta, Long idTipoRespuesta);

}

