package com.ejie.y41e.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41e.model.Y41eOrigen;
import com.ejie.y41e.utils.Y41eSqlUtils;

/**
 * Y41eOrigenDaoImpl
 *  
 */

@Repository
@Transactional
public class Y41eOrigenDaoImpl extends Y41eGenericoDaoImpl<Y41eOrigen> implements Y41eOrigenDao {

    public static final String TABLA="Y41E06S01";
    public static final String SECUENCIA="Y41E06Q00";
    public static final String ID_ORIGEN_006="ID_ORIGEN_006";
    public static final String DESC_ES_006="DESC_ES_006";
    public static final String DESC_EU_006="DESC_EU_006";
    public static final String ACTIVA_006="ACTIVA_006";
    protected static final String[] ORDER_BY_WHITE_LIST = new String[] { ID_ORIGEN_006, DESC_ES_006, DESC_EU_006, ACTIVA_006};

    /**
     * Y41eOrigenDaoImpl
     */
    public Y41eOrigenDaoImpl() {
        super(Y41eOrigen.class);
    }

    /*
     * ROW_MAPPERS
     */
    private final RowMapper<Y41eOrigen> rwMap = new RowMapper<Y41eOrigen>() {
        @Override
        public Y41eOrigen mapRow(ResultSet resultSet, int rowNum) throws SQLException {
            return new Y41eOrigen(
                    resultSet.getLong(ID_ORIGEN_006), resultSet.getString(DESC_ES_006), resultSet.getString(DESC_EU_006), resultSet.getString(ACTIVA_006)
                    );
        }
    };

    private final RowMapper<Y41eOrigen> rwMapPK = new RowMapper<Y41eOrigen>() {
        @Override
        public Y41eOrigen mapRow(ResultSet resultSet, int rowNum) throws SQLException {
            return new Y41eOrigen(
                    resultSet.getLong(ID_ORIGEN_006)
                    ); 
        }
    };

    /*
     * OPERACIONES CRUD
     */

    /**
     * Inserts a single row in the Y41eOrigen table.
     *
     * @param origen Y41eOrigen
     * @return Y41eOrigen
     */
    @Override
    public Y41eOrigen add(Y41eOrigen origen) {
        StringBuilder insert = new StringBuilder(Y41eSqlUtils.INSERT)
                .append(TABLA).append(" (")
                .append(ID_ORIGEN_006).append(",")
                .append(DESC_ES_006).append(",")
                .append(DESC_EU_006).append(",")
                .append(ACTIVA_006).append(")")
                .append("VALUES (")
                .append(SECUENCIA)
                .append(".NEXTVAL,?,?,?)");
        this.getJdbcTemplate().update(insert.toString(), origen.getDescEs(), origen.getDescEu(), origen.getActiva());
        return origen;
    }

    /**
     * Updates a single row in the Y41eOrigen table.
     *
     * @param origen Y41eOrigen
     * @return Y41eOrigen
     */
    @Override
    public Y41eOrigen update(Y41eOrigen origen) {
        StringBuilder update = new StringBuilder(Y41eSqlUtils.UPDATE)
                .append(TABLA).append(" SET ")
                .append(DESC_ES_006).append("=?,")
                .append(DESC_EU_006).append("=?,")
                .append(ACTIVA_006).append("=? ")
                .append(Y41eSqlUtils.WHERE)
                .append(ID_ORIGEN_006).append("=?");
        this.getJdbcTemplate().update(update.toString(), origen.getDescEs(), origen.getDescEu(), origen.getActiva(), origen.getIdOrigen());
        return origen;
    }

    /**
     * Removes a single row in the Y41eOrigen table.
     *
     * @param origen Y41eOrigen
     * @return
     */
    @Override
    public void remove(Y41eOrigen origen) {
        StringBuilder delete = new StringBuilder(Y41eSqlUtils.DELETE).append(TABLA).append(Y41eSqlUtils.WHERE).append(ID_ORIGEN_006).append("=?");
        this.getJdbcTemplate().update(delete.toString(), origen.getIdOrigen());
    }

    /* (non-Javadoc)
     * @see com.ejie.y41e.dao.Y41eGenericoDaoImpl#getSelect()
     */
    @Override
    protected String getSelect() {
        StringBuilder select = new StringBuilder("SELECT ")
                .append(ID_ORIGEN_006).append(",")
                .append(DESC_ES_006).append(",")
                .append(DESC_EU_006).append(",")
                .append(ACTIVA_006);
        return select.toString();
    }

    /* (non-Javadoc)
     * @see com.ejie.y41e.dao.Y41eGenericoDaoImpl#getFrom()
     */
    @Override
    protected String getFrom() {
        StringBuilder from = new StringBuilder(" FROM ").append(TABLA);
        return from.toString();
    }

    /* (non-Javadoc)
     * @see com.ejie.y41e.dao.Y41eGenericoDaoImpl#getRwMap()
     */
    @Override
    protected RowMapper<Y41eOrigen> getRwMap() {
        return this.rwMap;
    }

    /* (non-Javadoc)
     * @see com.ejie.y41e.dao.Y41eGenericoDaoImpl#getPK()
     */
    @Override
    protected String getPK() {
        return ID_ORIGEN_006;
    }

    /* (non-Javadoc)
     * @see com.ejie.y41e.dao.Y41eGenericoDaoImpl#getRwMapPK()
     */
    @Override
    protected RowMapper<Y41eOrigen> getRwMapPK() {
        return this.rwMapPK;
    }

    /* (non-Javadoc)
     * @see com.ejie.y41e.dao.Y41eGenericoDaoImpl#getWherePK(java.lang.Object, java.util.List)
     */
    @Override
    protected String getWherePK(Y41eOrigen bean, List<Object> params) {
        StringBuilder wherePK = new StringBuilder();
        wherePK.append(Y41eSqlUtils.WHERE).append(ID_ORIGEN_006).append("=?");
        params.add(bean.getIdOrigen());
        return wherePK.toString();

    }

    /* (non-Javadoc)
     * @see com.ejie.y41e.dao.Y41eGenericoDaoImpl#getWhere(java.lang.Object, java.util.List)
     */
    @Override
    protected String getWhere(Y41eOrigen bean, List<Object> params) {
        StringBuilder where = new StringBuilder(Y41eOrigenDaoImpl.STRING_BUILDER_INIT);

        if (bean  != null){
            where.append(Y41eSqlUtils.generarWhereIgual(ID_ORIGEN_006, bean.getIdOrigen(), params));
            where.append(Y41eSqlUtils.generarWhereIgual(DESC_ES_006, bean.getDescEs(), params));
            where.append(Y41eSqlUtils.generarWhereIgual(DESC_EU_006, bean.getDescEu(), params));
            where.append(Y41eSqlUtils.generarWhereIgual(ACTIVA_006, bean.getActiva(), params));
        }

        return where.toString();
    }

    /* (non-Javadoc)
     * @see com.ejie.y41e.dao.Y41eGenericoDaoImpl#getWhereLike(java.lang.Object, java.lang.Boolean, java.util.List, java.lang.Boolean)
     */
    @Override
    protected String getWhereLike(Y41eOrigen bean, Boolean startsWith, List<Object> params, Boolean search) {
        StringBuilder where = new StringBuilder(Y41eOrigenDaoImpl.STRING_BUILDER_INIT);

        if (bean  != null){
            where.append(Y41eSqlUtils.generarWhereIgual(ID_ORIGEN_006, bean.getIdOrigen(), params));
            where.append(Y41eSqlUtils.generarWhereLikeNormalizado(DESC_ES_006, bean.getDescEs(), params, startsWith));
            where.append(Y41eSqlUtils.generarWhereLikeNormalizado(DESC_EU_006, bean.getDescEu(), params, startsWith));
            where.append(Y41eSqlUtils.generarWhereIgual(ACTIVA_006, bean.getActiva(), params));
        }
        return where.toString();
    }

    /* (non-Javadoc)
     * @see com.ejie.y41e.dao.Y41eGenericoDaoImpl#getOrderBy()
     */
    @Override
    protected String[] getOrderBy() {
        return Y41eOrigenDaoImpl.ORDER_BY_WHITE_LIST;
    }

    /**
     * StringBuilder initilization value
     */
    public static final int STRING_BUILDER_INIT = 4096;

}