package com.ejie.y41e.dao;

import java.util.List;

import com.ejie.y41e.model.Y41eEnvio;

/**
 * Y41eEnviosDao
 *  
 */

public interface Y41eEnviosDao extends Y41eGenericoDao<Y41eEnvio>{

    /**
     * Guarda los envíos
     * @param listaEnvios List<Y41eEnvio>
     */
    public void guardarEnvios(List<Y41eEnvio> listaEnvios);

    /**
     * Actualiza la fecha de respuesta
     * @param idEnvio Long
     */
    public void actualizarFechaRespuesta(Long idEnvio);

    /**
     * Inserta un registro en la tabla Y41E10T00 para los casos de encuestas de sondeo
     * @param idEncuesta
     * @return
     */
    public Long addEnvioSondeo(Long idEncuesta);

}

