package com.ejie.y41e.dao;

import java.util.List;

import com.ejie.y41e.model.Y41eEncuesta;
import com.ejie.y41e.model.Y41eGrafico;
import com.ejie.y41e.model.Y41eResultados;

/**
 * Y41eEncuestaDao
 *  
 */

public interface Y41eEncuestaDao extends Y41eGenericoDao<Y41eEncuesta>{

    /**
     * Comprueba que no existe ninguna encuesta enviada o respondida para el id de la encuesta.
     * 
     * @param idEncuesta Long
     * @return String el area a la que pertence la encuesta 
     *            
     */
    public String validarEncuesta(Long idEncuesta);

    /**
     * Crea una encuesta como copia de la que recibe por parámetro
     * @param y41eEncuesta Y41eEncuesta
     * @return Y41eEncuesta
     */
    public Y41eEncuesta copiarEncuesta(Y41eEncuesta y41eEncuesta);

    /**
     * Obtiene las preguntas de la encuesta
     * @param resultado Y41eResultados
     * @return List<Y41eGrafico>
     */
    public List<Y41eGrafico> getGraficosEncuesta(Y41eResultados resultado);

    /**
     * Obtiene los datos para generar el excel de encuesta
     * @param y41eEncuesta
     * @return List<Y41eResultados>
     */
    public List<Y41eResultados> getExcelEncuesta(Y41eEncuesta y41eEncuesta);

    /**
     * Cambia la encuesta a enviada y actualiza la fecha de envio
     * @param encuesta Y41eEncuesta
     */
    public void enviarEncuesta(Y41eEncuesta encuesta);

    /**
     * Obtiene la encuesta según el parámetro
     * @param param
     * @return
     */
    public Y41eEncuesta getEncuestaWsByParam(String param);

    /**
     * Obtiene la encuesta según el parámetro  en la tabla Y41E01T00
     * @param param
     * @return
     */
    public Y41eEncuesta getEncuestaByParam(String param);

}

