package com.ejie.y41e.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41e.dao.rwmap.Y41eConfiguracionRowMapper;
import com.ejie.y41e.model.Y41eConfiguracion;
import com.ejie.y41e.utils.Y41eSqlUtils;

/**
 * Y41eConfiguracionDaoImpl
 *  
 */

@Repository
@Transactional
public class Y41eConfiguracionDaoImpl extends Y41eGenericoDaoImpl<Y41eConfiguracion> implements Y41eConfiguracionDao {

    public static final String TABLA="Y41E12S01";
    public static final String ID_CONFIG_012="ID_CONFIG_012";
    public static final String EMAIL_012="EMAIL_012";
    public static final String ASUNTO_ES_012="ASUNTO_ES_012";
    public static final String ASUNTO_EU_012="ASUNTO_EU_012";
    public static final String MENSAJE_ES_012="MENSAJE_ES_012";
    public static final String MENSAJE_EU_012="MENSAJE_EU_012";
    protected static final String[] ORDER_BY_WHITE_LIST = new String[] { ID_CONFIG_012, EMAIL_012, ASUNTO_ES_012, ASUNTO_EU_012,
            MENSAJE_ES_012, MENSAJE_EU_012};

    /**
     * Y41eConfiguracionDaoImpl
     */
    public Y41eConfiguracionDaoImpl() {
        super(Y41eConfiguracion.class);
    }

    /*
     * ROW_MAPPERS
     */
    private final RowMapper<Y41eConfiguracion> rwMapPK = new RowMapper<Y41eConfiguracion>() {
        @Override
        public Y41eConfiguracion mapRow(ResultSet resultSet, int rowNum) throws SQLException {
            return new Y41eConfiguracion(resultSet.getInt(ID_CONFIG_012)); 
        }
    };


    /*
     * OPERACIONES CRUD
     */

    /**
     * Inserts a single row in the Y41eConfiguracion table.
     *
     * @param config Y41eConfiguracion
     * @return Y41eConfiguracion
     */
    @Override
    public Y41eConfiguracion add(Y41eConfiguracion config) {
        StringBuilder insert = new StringBuilder(Y41eSqlUtils.INSERT)
                .append(TABLA).append(" (")
                .append(ID_CONFIG_012).append(",")
                .append(EMAIL_012).append(",")
                .append(ASUNTO_ES_012).append(",")
                .append(ASUNTO_EU_012).append(",")
                .append(MENSAJE_ES_012).append(",")
                .append(MENSAJE_EU_012).append(")")
                .append("VALUES (?,?,?,?,?)");
        this.getJdbcTemplate().update(insert.toString(), config.getIdConfig(), config.getEmail(), config.getAsuntoEs(), config.getAsuntoEu(), config.getMensajeEs(), config.getMensajeEu());
        return config;
    }

    /**
     * Updates a single row in the Y41eConfiguracion table.
     *
     * @param config Y41eConfiguracion
     * @return Y41eConfiguracion
     */
    @Override
    public Y41eConfiguracion update(Y41eConfiguracion config) {
        StringBuilder update = new StringBuilder(Y41eSqlUtils.UPDATE)
                .append(TABLA).append(" SET ")
                .append(EMAIL_012).append("=?,")
                .append(ASUNTO_ES_012).append("=?,")
                .append(ASUNTO_EU_012).append("=?,")
                .append(MENSAJE_ES_012).append("=?, ")
                .append(MENSAJE_EU_012).append("=? ")
                .append(Y41eSqlUtils.WHERE)
                .append(ID_CONFIG_012).append("=?");
        this.getJdbcTemplate().update(update.toString(), config.getEmail(), config.getAsuntoEs(), config.getAsuntoEu(), config.getMensajeEs(), config.getMensajeEu(), config.getIdConfig());
        return config;
    }

    /**
     * Removes a single row in the Y41eConfiguracion table.
     *
     * @param config Y41eConfiguracion
     * @return
     */
    @Override
    public void remove(Y41eConfiguracion config) {
        StringBuilder delete = new StringBuilder(Y41eSqlUtils.DELETE).append(TABLA).append(Y41eSqlUtils.WHERE).append(ID_CONFIG_012).append("=?");
        this.getJdbcTemplate().update(delete.toString(), config.getIdConfig());
    }

    /* (non-Javadoc)
     * @see com.ejie.y41e.dao.Y41eGenericoDaoImpl#getSelect()
     */
    @Override
    protected String getSelect() {
        StringBuilder select = new StringBuilder("SELECT ")
                .append(ID_CONFIG_012).append(",")
                .append(EMAIL_012).append(",")
                .append(ASUNTO_ES_012).append(",")
                .append(ASUNTO_EU_012).append(",")
                .append(MENSAJE_ES_012).append(",")
                .append(MENSAJE_EU_012);
        return select.toString();
    }

    /* (non-Javadoc)
     * @see com.ejie.y41e.dao.Y41eGenericoDaoImpl#getFrom()
     */
    @Override
    protected String getFrom() {
        StringBuilder from = new StringBuilder(" FROM ").append(TABLA);
        return from.toString();
    }

    /* (non-Javadoc)
     * @see com.ejie.y41e.dao.Y41eGenericoDaoImpl#getRwMap()
     */
    @Override
    protected RowMapper<Y41eConfiguracion> getRwMap() {
        return new Y41eConfiguracionRowMapper();
    }

    /* (non-Javadoc)
     * @see com.ejie.y41e.dao.Y41eGenericoDaoImpl#getPK()
     */
    @Override
    protected String getPK() {
        return ID_CONFIG_012;
    }

    /* (non-Javadoc)
     * @see com.ejie.y41e.dao.Y41eGenericoDaoImpl#getRwMapPK()
     */
    @Override
    protected RowMapper<Y41eConfiguracion> getRwMapPK() {
        return this.rwMapPK;
    }

    /* (non-Javadoc)
     * @see com.ejie.y41e.dao.Y41eGenericoDaoImpl#getWherePK(java.lang.Object, java.util.List)
     */
    @Override
    protected String getWherePK(Y41eConfiguracion bean, List<Object> params) {
        StringBuilder wherePK = new StringBuilder();
        wherePK.append(Y41eSqlUtils.WHERE).append(ID_CONFIG_012).append("=?");
        params.add(bean.getIdConfig());
        return wherePK.toString();

    }

    /* (non-Javadoc)
     * @see com.ejie.y41e.dao.Y41eGenericoDaoImpl#getWhere(java.lang.Object, java.util.List)
     */
    @Override
    protected String getWhere(Y41eConfiguracion bean, List<Object> params) {
        StringBuilder where = new StringBuilder(Y41eConfiguracionDaoImpl.STRING_BUILDER_INIT);

        if (bean  != null){
            where.append(Y41eSqlUtils.generarWhereIgual(ID_CONFIG_012, bean.getIdConfig(), params));
            where.append(Y41eSqlUtils.generarWhereIgual(ASUNTO_ES_012, bean.getAsuntoEs(), params));
            where.append(Y41eSqlUtils.generarWhereIgual(ASUNTO_EU_012, bean.getAsuntoEu(), params));
            where.append(Y41eSqlUtils.generarWhereIgual(MENSAJE_ES_012, bean.getMensajeEs(), params));
            where.append(Y41eSqlUtils.generarWhereIgual(MENSAJE_EU_012, bean.getMensajeEu(), params));
        }

        return where.toString();
    }

    /* (non-Javadoc)
     * @see com.ejie.y41e.dao.Y41eGenericoDaoImpl#getWhereLike(java.lang.Object, java.lang.Boolean, java.util.List, java.lang.Boolean)
     */
    @Override
    protected String getWhereLike(Y41eConfiguracion bean, Boolean startsWith, List<Object> params, Boolean search) {
        StringBuilder where = new StringBuilder(Y41eConfiguracionDaoImpl.STRING_BUILDER_INIT);

        if (bean  != null){
            where.append(Y41eSqlUtils.generarWhereIgual(ID_CONFIG_012, bean.getIdConfig(), params));
            where.append(Y41eSqlUtils.generarWhereLikeNormalizado(ASUNTO_ES_012, bean.getAsuntoEs(), params, startsWith));
            where.append(Y41eSqlUtils.generarWhereLikeNormalizado(ASUNTO_EU_012, bean.getAsuntoEu(), params, startsWith));
            where.append(Y41eSqlUtils.generarWhereLikeNormalizado(MENSAJE_ES_012, bean.getMensajeEs(), params, startsWith));
            where.append(Y41eSqlUtils.generarWhereLikeNormalizado(MENSAJE_EU_012, bean.getMensajeEu(), params, startsWith));
        }
        return where.toString();
    }

    /* (non-Javadoc)
     * @see com.ejie.y41e.dao.Y41eGenericoDaoImpl#getOrderBy()
     */
    @Override
    protected String[] getOrderBy() {
        return Y41eConfiguracionDaoImpl.ORDER_BY_WHITE_LIST;
    }

    /**
     * StringBuilder initilization value
     */
    public static final int STRING_BUILDER_INIT = 4096;

}